/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.profile;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.JVoiceXMLEvent;
import org.jvoicexml.interpreter.FormInterpretationAlgorithm;
import org.jvoicexml.interpreter.FormItem;
import org.jvoicexml.interpreter.FormItemLocalExecutableTagContainer;
import org.jvoicexml.interpreter.VoiceXmlInterpreter;
import org.jvoicexml.interpreter.VoiceXmlInterpreterContext;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.profile.Profile;
import org.jvoicexml.profile.TagStrategy;
import org.jvoicexml.profile.TagStrategyFactory;
import org.jvoicexml.xml.VoiceXmlNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TagStrategyExecutor {
    private static final Logger LOGGER = LogManager.getLogger(TagStrategyExecutor.class);
    private final TagStrategyFactory factory;

    public TagStrategyExecutor(Profile profile) {
        this.factory = profile.getTagStrategyFactory();
    }

    public void executeChildNodes(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem formItem) throws JVoiceXMLEvent {
        VoiceXmlNode currentNode = formItem.getNode();
        NodeList children = currentNode.getChildNodes();
        this.executeChildNodes(context, interpreter, fia, formItem, children);
    }

    public void executeChildNodes(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem formItem, VoiceXmlNode parent) throws JVoiceXMLEvent {
        NodeList children = parent.getChildNodes();
        this.executeChildNodes(context, interpreter, fia, formItem, children);
    }

    public void executeChildNodesLocal(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem formItem, FormItemLocalExecutableTagContainer container) throws JVoiceXMLEvent {
        Collection<VoiceXmlNode> nodes = container.getLocalExecutableTags();
        for (VoiceXmlNode node : nodes) {
            TagStrategy strategy = this.prepareTagStrategyExecution(context, fia, node);
            if (strategy == null) continue;
            strategy.execute(context, interpreter, fia, formItem, node);
        }
    }

    public void executeChildNodes(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem formItem, NodeList list) throws JVoiceXMLEvent {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            VoiceXmlNode node = (VoiceXmlNode)list.item(i);
            this.executeTagStrategy(context, interpreter, fia, formItem, node);
        }
    }

    public void executeTagStrategy(VoiceXmlInterpreterContext context, VoiceXmlInterpreter interpreter, FormInterpretationAlgorithm fia, FormItem formItem, VoiceXmlNode node) throws JVoiceXMLEvent {
        TagStrategy strategy = this.prepareTagStrategyExecution(context, fia, node);
        if (strategy != null) {
            strategy.execute(context, interpreter, fia, formItem, node);
        }
    }

    private TagStrategy prepareTagStrategyExecution(VoiceXmlInterpreterContext context, FormInterpretationAlgorithm fia, VoiceXmlNode node) throws ErrorEvent {
        TagStrategy strategy = this.factory.getTagStrategy((Node)node);
        if (strategy == null) {
            return null;
        }
        strategy.getAttributes(context, fia, node);
        strategy.evalAttributes(context);
        DataModel model = context.getDataModel();
        if (LOGGER.isDebugEnabled()) {
            strategy.dumpNode(model, node);
        }
        strategy.validateAttributes(model);
        return strategy;
    }
}

