/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.startup;

import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.startup.RemoteShutdown;

public final class Shutdown {
    private static final Logger LOGGER = LogManager.getLogger(Shutdown.class);

    private Shutdown() {
    }

    private Configuration getConfiguration() {
        ServiceLoader<Configuration> services = ServiceLoader.load(Configuration.class);
        Iterator<Configuration> iterator = services.iterator();
        if (iterator.hasNext()) {
            Configuration config = iterator.next();
            return config;
        }
        return null;
    }

    private RemoteShutdown getRemoteShutdown(Configuration configuration) throws ConfigurationException {
        Collection<RemoteShutdown> shutdowns = configuration.loadObjects(RemoteShutdown.class, "jndi");
        Iterator<RemoteShutdown> iterator = shutdowns.iterator();
        if (iterator.hasNext()) {
            RemoteShutdown shutdown = iterator.next();
            return shutdown;
        }
        return null;
    }

    public static void main(String[] args) {
        Shutdown shutdown = new Shutdown();
        Configuration configuration = shutdown.getConfiguration();
        if (configuration == null) {
            LOGGER.fatal("No configuration found.");
            return;
        }
        try {
            RemoteShutdown remote = shutdown.getRemoteShutdown(configuration);
            if (remote == null) {
                LOGGER.fatal("no remote shutdown configured");
                return;
            }
            remote.shutdown();
        }
        catch (ConfigurationException e) {
            LOGGER.fatal(e.getMessage(), (Throwable)e);
            return;
        }
    }
}

