/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl;

import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Properties;
import org.jwall.rbl.data.RBList;
import org.jwall.rbl.data.RBListEntry;
import org.jwall.rbl.data.RblFile;
import org.jwall.rbl.data.RblSettings;
import org.jwall.rbl.dns.Query;
import org.jwall.rbl.dns.QueryHandler;
import org.jwall.rbl.dns.RblSecurityManager;
import org.jwall.rbl.dns.Response;
import org.jwall.rbl.net.AdminHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RblServer
extends Thread {
    public static final String RBL_HOME = "RBL_HOME";
    public static final String RBL_PORT = "rbl.port";
    public static final String RBL_ADDRESS = "rbl.address";
    public static final String RBL_ADMIN_PORT = "rbl.admin.port";
    public static final String RBL_FILE = "rbl.file";
    public static final String RBL_DOMAIN = "rbl.domain";
    public static final String RBL_PERMISSIONS = "rbl.permission.file";
    public static final String[] PROPERTY_NAMES = new String[]{"rbl.port", "rbl.address", "rbl.admin.port", "rbl.file", "rbl.domain", "rbl.permission.file"};
    public static Inet4Address BLOCKED_VALUE = null;
    public static final String VERSION = "0.3";
    public Logger log = LoggerFactory.getLogger(RblServer.class);
    RBList rbl;
    String domain = "rbl.localnet";
    DatagramSocket socket;
    long queryCount = 0L;
    boolean running = true;
    int adminPort = -1;
    AdminHandler adminInterface;
    QueryHandler queryHandler;
    RblSecurityManager securityManager;

    public RblServer(Properties p) throws Exception {
        String addr = "127.0.0.1";
        Integer port = 15353;
        File rblFile = new File(File.separator + "var" + File.separator + "lib" + File.separator + "jwall-rbl" + File.separator + "local.rbl");
        try {
            if (p.getProperty(RBL_PORT) != null) {
                port = new Integer(p.getProperty(RBL_PORT));
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid port '" + p.getProperty(RBL_PORT) + "' specified!");
        }
        try {
            if (p.getProperty(RBL_ADDRESS) != null) {
                addr = InetAddress.getByName(p.getProperty(RBL_ADDRESS)).getHostAddress();
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to set address '" + p.getProperty(RBL_ADDRESS) + "'!");
        }
        if (p.getProperty(RBL_DOMAIN) != null) {
            this.domain = p.getProperty(RBL_DOMAIN);
        }
        try {
            if (p.getProperty(RBL_ADMIN_PORT) != null) {
                this.adminPort = new Integer(p.getProperty(RBL_ADMIN_PORT));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (p.getProperty(RBL_FILE) != null) {
                rblFile = new File(p.getProperty(RBL_FILE));
            }
            this.rbl = new RblFile(rblFile);
        }
        catch (Exception e) {
            throw new Exception("Failed to read rbl-list from file '': " + e.getMessage());
        }
        File policyFile = new File(File.separator + "etc" + File.separator + "jwall-rbld.permissions");
        try {
            if (p.getProperty(RBL_PERMISSIONS) != null) {
                policyFile = new File(p.getProperty(RBL_PERMISSIONS));
            }
            if (policyFile.isFile()) {
                RblSecurityManager.getInstance().readPermissions(policyFile);
            } else {
                this.log.debug("Permission file {} does not exist, updates of DNS is disabled.", (Object)policyFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to load permissions from '" + policyFile.getAbsolutePath() + "': " + e.getMessage());
        }
        this.log.debug("Starting jwall-rbld version {} for domain '{}'", (Object)VERSION, (Object)this.getDomain());
        this.log.debug("Listening on UDP port {}:{}", (Object)addr, (Object)port);
        this.queryHandler = new QueryHandler(this);
        this.socket = new DatagramSocket(port, InetAddress.getByName(addr));
        this.setDaemon(true);
    }

    public RblServer(InetAddress addr, Integer port) throws Exception {
        this.log.debug("Creating RblServer listening at {}, port {}", (Object)addr.getHostAddress(), (Object)port);
        this.queryHandler = new QueryHandler(this);
        this.socket = new DatagramSocket(port, addr);
    }

    public void setRblSecurityManager(RblSecurityManager manager) {
        this.securityManager = manager;
    }

    public RblSecurityManager getRblSecurityManager() {
        if (this.securityManager != null) {
            return this.securityManager;
        }
        return RblSecurityManager.getInstance();
    }

    public void setBlockList(RBList list) {
        this.rbl = list;
    }

    public RBList getBlockList() {
        return this.rbl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void block(String address, Integer ttl) {
        String key = QueryHandler.getKeyForAddress(address, this.getDomain());
        this.log.debug("Adding rbl-entry with key = '{}'", (Object)key);
        RBListEntry entry = new RBListEntry(null, key);
        entry.setName(address);
        entry.setCreated(System.currentTimeMillis());
        entry.setLifetime(ttl);
        this.getBlockList().add(entry);
    }

    public void unblock(String address) {
        String key = QueryHandler.getKeyForAddress(address, this.getDomain());
        this.log.debug("Removing rbl-entry with key = '{}'", (Object)key);
        this.getBlockList().remove(key);
    }

    @Override
    public void run() {
        try {
            if (this.adminPort > 0) {
                this.log.debug("Starting admin interface on port {}", (Object)this.adminPort);
                this.adminInterface = new AdminHandler(this, "localhost", this.adminPort);
                this.adminInterface.start();
            } else {
                this.log.debug("No admin-port defined, not starting admin interface!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.socket.setSoTimeout(1000);
        }
        catch (Exception e) {
            // empty catch block
        }
        while (this.running) {
            try {
                DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
                this.log.debug("Waiting for incoming DNS queries...");
                this.socket.receive(packet);
                this.log.debug("Received packet {}... size is {}", (Object)(packet.getAddress() + ":" + packet.getPort()), (Object)packet.getLength());
                byte[] data = packet.getData();
                this.log.debug("Received packet of size {} bytes: {}", (Object)data.length, (Object)new String(data));
                Query q = Query.parse(data, 0);
                Response response = this.queryHandler.process(packet.getAddress(), q);
                byte[] re = response.toByteArray();
                DatagramPacket answer = new DatagramPacket(re, 0);
                answer.setLength(re.length);
                answer.setAddress(packet.getAddress());
                answer.setPort(packet.getPort());
                this.socket.send(answer);
                ++this.queryCount;
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log.info("Closing UDP socket...");
        this.socket.close();
    }

    public void shutdown() {
        this.log.info("Received shutdown signal!");
        this.rbl.store();
        if (this.adminInterface != null) {
            this.adminInterface.shutdown();
            try {
                this.adminInterface.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.log.info("Setting running=false");
        this.running = false;
        this.log.info("Sending interrupt() signal...");
        this.interrupt();
        this.log.info("Disconnecting socket...");
        this.socket.disconnect();
    }

    public static void main(String[] args) throws Exception {
        String base = System.getenv(RBL_HOME);
        if (base == null) {
            base = "";
        }
        String config = base + File.separator + "etc" + File.separator + "jwall-rbld.conf";
        if (args.length > 0) {
            config = args[0];
        } else {
            String[] etcs;
            for (String etc : etcs = new String[]{base + "/etc/jwall-rbld.conf", "/etc/jwall-rbld.conf", "/opt/modsecurity/etc/jwall-rbld.conf"}) {
                File ef = new File(etc);
                if (!ef.exists()) continue;
                config = ef.getAbsolutePath();
                break;
            }
        }
        RblSettings p = RblSettings.read(config);
        final RblServer server = new RblServer(p);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.shutdown();
            }
        });
        server.log.debug("RblServer.run()");
        server.run();
        server.log.debug("RBL server exiting.");
    }

    static {
        try {
            BLOCKED_VALUE = (Inet4Address)InetAddress.getByName("127.0.0.1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (System.getProperty("rbl.log") == null) {
            System.setProperty("rbl.log", "/var/log/jwall-rbld.log");
        }
    }
}

