/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jwall.rbl.data.RBList;
import org.jwall.rbl.data.RBListEntry;
import org.jwall.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RblFile
implements RBList {
    static Logger log = LoggerFactory.getLogger(RblFile.class);
    File source;
    Map<String, RBListEntry> entries = new HashMap<String, RBListEntry>();
    Integer maxId = 1;

    public RblFile(File file) throws IOException {
        this.source = file;
        if (this.source == null) {
            this.source = new File(File.separator + "opt" + File.separator + "modsecurity" + File.separator + "var" + File.separator + "jwall.rbl");
        }
        log.debug("RBL file is {}", (Object)this.source);
        this.readDatabase(this.source);
    }

    protected void readDatabase(File file) throws IOException {
        log.debug("Reading existing RBL list from {}", (Object)file);
        if (!file.isFile()) {
            log.debug("RblFile {} does not exist, cannot read stored entries.", (Object)file);
            return;
        }
        BufferedReader r = new BufferedReader(new FileReader(file));
        String line = r.readLine();
        while (line != null) {
            String l = line.trim();
            if (!l.startsWith("#")) {
                log.debug("Found RBL entry: {}", (Object)l);
                try {
                    String[] tok = line.split(";");
                    RBListEntry entry = new RBListEntry(new Integer(tok[0]), tok[1]);
                    this.maxId = Math.max(this.maxId, entry.getId());
                    entry.setName(tok[2]);
                    entry.setCreated(new Long(tok[3]));
                    if (tok.length > 4) {
                        entry.setLifetime(new Integer(tok[4]));
                    }
                    if (tok.length > 5) {
                        entry.setComment(tok[5]);
                    }
                    this.entries.put(entry.getKey(), entry);
                }
                catch (Exception e) {
                    log.error("Failed to parse RBL entry: {}", (Object)e.getMessage());
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                }
            } else {
                log.debug("Skipping comment line '{}'", (Object)l);
            }
            line = r.readLine();
        }
        r.close();
        log.debug("{} RBL entries loaded.", (Object)this.entries.size());
    }

    public void store(OutputStream o) throws IOException {
        log.debug("Storing RBL list to CSV file format...");
        PrintStream out = new PrintStream(o);
        int i = 0;
        for (RBListEntry e : this.entries.values()) {
            out.print(e.getId());
            out.print(";");
            out.print(e.getKey());
            out.print(";");
            out.print(e.getName());
            out.print(";");
            out.print(e.getCreated());
            out.print(";");
            out.print(e.getLifetime());
            out.print(";");
            out.print(e.getComment());
            out.println();
            ++i;
        }
        out.flush();
        out.close();
        log.debug("{} entries written.", (Object)i);
    }

    @Override
    public void add(RBListEntry entry) {
        log.debug("Adding object with key '{}'", (Object)entry.getKey());
        if (entry.getId() == null) {
            this.maxId = this.maxId + 1;
            entry.setId(this.maxId);
        }
        this.entries.put(entry.getKey(), entry);
    }

    @Override
    public boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public RBListEntry lookup(String name) {
        log.debug("Looking up object by key '{}'", (Object)name);
        return this.entries.get(name);
    }

    @Override
    public boolean remove(String name) {
        return this.entries.remove(name) != null;
    }

    @Override
    public List<RBListEntry> search(String query) {
        ArrayList<RBListEntry> results = new ArrayList<RBListEntry>();
        for (String key : this.entries.keySet()) {
            if (!WildcardMatcher.matches(query, key)) continue;
            results.add(this.entries.get(key));
        }
        return results;
    }

    @Override
    public void store() {
        block6: {
            if (this.source == null) {
                return;
            }
            try {
                if (!this.source.getParentFile().isDirectory()) {
                    this.source.getParentFile().mkdirs();
                }
            }
            catch (Exception e) {
                log.error("Failed to create storage directory for RBL: " + e.getMessage());
            }
            try {
                log.info("Storing rbl data in {}", (Object)this.source.getAbsolutePath());
                this.store(new FileOutputStream(this.source));
            }
            catch (Exception e) {
                log.error("Failed to store block-list: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
    }
}

