/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jwall.rbl.dns.Query;
import org.jwall.rbl.dns.QuerySection;
import org.jwall.rbl.dns.ResourceRecord;

public class Response {
    public static final int RESPONSE_FLAG = 32768;
    public static final int OP_QUERY = 0;
    public static final int OP_IQUERY = 1;
    public static final int OP_STATUS = 2;
    public static final int OP_RESERVED = 3;
    public static final int OP_NOTIFY = 4;
    public static final int OP_UPDATE = 5;
    public static final int AUTHORITATIVE_FLAG = 1024;
    public static final int TRUNCATION_FLAG = 512;
    public static final int RD_FLAG = 256;
    public static final int RA_FLAG = 128;
    public static final int RC_NO_ERROR = 0;
    public static final int RC_FORMAT_ERROR = 1;
    public static final int RC_SERVER_FAILURE = 2;
    public static final int RC_NAME_ERROR = 3;
    public static final int RC_NOT_IMPLEMENTED = 4;
    public static final int RC_REFUSED = 5;
    public static final int RC_XY_DOMAIN = 6;
    public static final int RC_YX_RR_SET = 7;
    public static final int RC_NX_RR_SET = 8;
    public static final int RC_NOT_AUTH = 9;
    public static final int RC_NOT_ZONE = 10;
    int id;
    int arCount = 0;
    int nsCount = 0;
    int status = 0;
    ArrayList<QuerySection> queries = new ArrayList();
    ArrayList<ResourceRecord> answers = new ArrayList();

    public Response(Query q) {
        this.id = q.getId();
        this.queries.addAll(q.getSections());
    }

    public void add(ResourceRecord rr) {
        this.answers.add(rr);
    }

    public int getNumberOfRecords() {
        return this.answers.size();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] toByteArray() {
        int i = 0;
        int len = 12;
        ByteBuffer[] qs = new ByteBuffer[this.queries.size()];
        for (QuerySection q : this.queries) {
            byte[] b = q.toByteArray();
            qs[i++] = ByteBuffer.wrap(b);
            len += b.length;
        }
        i = 0;
        ByteBuffer[] rrs = new ByteBuffer[this.answers.size()];
        for (ResourceRecord rr : this.answers) {
            byte[] b = rr.toByteArray();
            rrs[i++] = ByteBuffer.wrap(b);
            len += b.length;
        }
        byte[] data = new byte[len];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.put((byte)((this.id & 0xFF00) >> 8));
        buf.put((byte)(this.id & 0xFF));
        int flags = 33792;
        buf.put((byte)((flags & 0xFF00) >> 8));
        buf.put((byte)(this.status & 7));
        buf.put((byte)((this.queries.size() & 0xFF00) >> 8));
        buf.put((byte)(this.queries.size() & 0xFF));
        buf.put((byte)((this.answers.size() & 0xFF00) >> 8));
        buf.put((byte)(this.answers.size() & 0xFF));
        buf.put((byte)((this.nsCount & 0xFF00) >> 8));
        buf.put((byte)(this.nsCount & 0xFF));
        buf.put((byte)((this.arCount & 0xFF00) >> 8));
        buf.put((byte)(this.arCount & 0xFF));
        for (ByteBuffer q : qs) {
            buf.put(q);
        }
        for (ByteBuffer rr : rrs) {
            buf.put(rr);
        }
        return data;
    }
}

