/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import org.jwall.rbl.RblServer;
import org.jwall.rbl.data.RBListEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminHandler
extends Thread {
    static Logger log = LoggerFactory.getLogger(AdminHandler.class);
    RblServer server;
    ServerSocket socket;
    boolean running = true;

    public AdminHandler(RblServer server, String addr, int port) throws Exception {
        this.socket = new ServerSocket(port);
        this.server = server;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket client = this.socket.accept();
                String remote = client.getInetAddress().getHostAddress();
                if (!remote.startsWith("127.0.0") && !remote.equals("0:0:0:0:0:0:0:1") || remote.equals("::1")) {
                    log.info("Client connect from {} rejected. Allowing localhost connections only!", (Object)client.getInetAddress().getHostAddress());
                    client.close();
                    continue;
                }
                ClientHandler handler = new ClientHandler(client, this.server);
                handler.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }

    public class ClientHandler
    extends Thread {
        RblServer server;
        PrintStream out;
        BufferedReader reader;
        Socket socket;
        boolean running = true;

        public ClientHandler(Socket socket, RblServer server) {
            this.setDaemon(true);
            this.socket = socket;
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.out = new PrintStream(this.socket.getOutputStream());
                this.out.println("\n   jwall.org RBL Server 0.3");
                this.out.print("   ---------------------");
                for (int i = 0; i < "0.3".length(); ++i) {
                    this.out.print("-");
                }
                this.out.println("\n");
                this.out.println("   Welcome to the jwall-rbl server, Version 0.3");
                this.out.println("   This interface allows you to manage the block-list of this server.");
                this.out.println("   Type 'help' to get an overview of the available commands!");
                while (this.running && this.socket.isConnected()) {
                    this.out.print("\n> ");
                    String line = this.reader.readLine();
                    if (line == null) continue;
                    this.eval(line.trim());
                }
                this.out.println("# Bye!");
                this.out.flush();
                this.out.close();
                this.socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void eval(String command) {
            String[] args = command.split("\\s+");
            if (args.length == 0) {
                return;
            }
            if ("help".startsWith(args[0])) {
                this.doHelp();
                return;
            }
            if ("list".startsWith(args[0])) {
                this.doList(args);
                return;
            }
            if ("search".startsWith(args[0])) {
                this.doSearch(args);
                return;
            }
            if ("block".startsWith(args[0])) {
                this.doBlock(args);
                return;
            }
            if ("unblock".startsWith(args[0])) {
                this.doUnblock(args);
                return;
            }
            if ("quit".startsWith(args[0]) || "exit".startsWith(args[0])) {
                this.running = false;
                return;
            }
            if ("shutdown".startsWith(args[0])) {
                this.doShutdown(args);
            }
            this.out.println("Unknown command '" + args[0] + "'!");
        }

        public void doHelp() {
            this.out.println("   This is a very simple interface for adding/removing entries");
            this.out.println("   from the server's block list.");
            this.out.println("   Any changes to the list will immediately affect the server's");
            this.out.println("   response, thus it may be used for instant blocking.\n");
            this.out.println("   The following commands are availble:\n");
            this.out.println("      'search'   - simply lists all active entries, matching a given");
            this.out.println("                   expression. '*' and '?' can be used as wildcards\n");
            this.out.println("      'list'     - Lists all entries currently active.\n");
            this.out.println("      'block'    - Creates a new list-entry. By default an entry will");
            this.out.println("                   be blocked for 60 seconds. You may additionally specify");
            this.out.println("                   any other number of seconds before this entry expires.\n");
            this.out.println("      'unblock'  - Removes an entry from the list.");
        }

        public void doList(String[] args) {
            this.doSearch(new String[]{"search", "*"});
        }

        public void doBlock(String[] args) {
            if (args.length == 1) {
                this.out.println("");
                this.out.println("   You need to specify an additional IP address to block!");
                this.out.println("   Example:");
                this.out.println("                  block 172.16.0.1\n");
                this.out.println("   You may also specify the number of seconds until the block ");
                this.out.println("   expires, e.g.");
                this.out.println("                  block 172.16.0.1 180\n");
                return;
            }
            try {
                String[] tok = args[1].split("\\.");
                StringBuffer key = new StringBuffer();
                for (int i = tok.length - 1; i >= 0; --i) {
                    key.append(tok[i]);
                    if (i <= 0) continue;
                    key.append(".");
                }
                if (!this.server.getDomain().startsWith(".")) {
                    key.append(".");
                }
                key.append(this.server.getDomain());
                RBListEntry entry = new RBListEntry(null, key.toString());
                entry.setName(args[1]);
                entry.setCreated(System.currentTimeMillis());
                try {
                    if (args.length > 2) {
                        entry.setLifetime(new Integer(args[2]));
                    }
                }
                catch (Exception e) {
                    entry.setLifetime(60);
                }
                entry.setComment("");
                this.server.getBlockList().add(entry);
                this.out.println("# Address '" + entry.getName() + "' added to block-list.");
            }
            catch (Exception e) {
                this.out.println("# Failed to create address '" + args[1] + "' - " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }

        public void doUnblock(String[] args) {
            try {
                String[] tok = args[1].split("\\.");
                StringBuffer key = new StringBuffer();
                for (int i = tok.length - 1; i >= 0; --i) {
                    key.append(tok[i]);
                    if (i <= 0) continue;
                    key.append(".");
                }
                if (!this.server.getDomain().startsWith(".")) {
                    key.append(".");
                }
                key.append(this.server.getDomain());
                this.server.getBlockList().remove(key.toString());
                this.out.println("# Removed '" + key.toString() + "' from block list.");
            }
            catch (Exception e) {
                this.out.println("Failed to remove address from block list: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public void doSearch(String[] args) {
            if (args.length == 1) {
                this.out.println("\n   The 'search' command needs an additional query string!");
                return;
            }
            try {
                List<RBListEntry> results = this.server.getBlockList().search(args[1]);
                for (RBListEntry entry : results) {
                    long expired = (entry.getExpiresAt() - System.currentTimeMillis()) / 1000L;
                    String expires = "  expires in " + expired + " seconds.";
                    if (expired < 0L) {
                        expires = "  expired " + Math.abs(expired) + " seconds ago.";
                        if (Math.abs(expired) > 120L) {
                            this.server.getBlockList().remove(entry.getName());
                            continue;
                        }
                    }
                    this.out.println("  " + entry.getName() + "   " + expires);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void doShutdown(String[] args) {
            block4: {
                this.out.print("Do you really want to shut down the RBL daemon?  (Y/N)  ");
                try {
                    String line = this.reader.readLine();
                    if (line != null && line.trim().matches("(Y|y)")) {
                        this.out.println();
                        this.out.println("Sending 'shutdown' command to server...");
                        this.server.shutdown();
                        this.running = false;
                    } else {
                        this.out.println("\nYou need to enter 'Y' or 'y' to shut down the RBL server.");
                    }
                }
                catch (Exception e) {
                    log.error("Error: {}", (Object)e.getMessage());
                    if (!log.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }
}

