/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jwall.audit.EventListener;
import org.jwall.audit.EventProcessor;
import org.jwall.audit.EventProcessorException;
import org.jwall.audit.EventProcessorPipeline;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventProcessorPipeline
implements EventProcessorPipeline<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(AuditEventProcessorPipeline.class);
    final LinkedList<EventProcessor<AuditEvent>> eventProcessors = new LinkedList();
    final Set<EventListener<AuditEvent>> eventListener = new LinkedHashSet<EventListener<AuditEvent>>();
    Map<EventProcessor<AuditEvent>, Double> priorities = new HashMap<EventProcessor<AuditEvent>, Double>();
    public static final Double DEFAULT_PRIORITY = 100.0;

    public AuditEvent processEvent(AuditEvent event) throws EventProcessorException {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (log.isDebugEnabled()) {
                log.debug("Processing next event[{}]...", (Object)event.getEventId());
                log.debug("ScriptEvent will be processed by {} event processors:", (Object)this.eventProcessors.size());
                for (EventProcessor eventProcessor : this.eventProcessors) {
                    log.debug("   {}", (Object)eventProcessor);
                }
            }
            for (EventProcessor eventProcessor : this.eventProcessors) {
                try {
                    long start = System.currentTimeMillis();
                    eventProcessor.processEvent(event, context);
                    long end = System.currentTimeMillis();
                    log.debug("Processing with {} took {}ms", (Object)eventProcessor, (Object)(end - start));
                }
                catch (Exception e) {
                    log.error("Processing failed: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
            if (context.containsKey("event.flag.delete")) {
                log.debug("ScriptEvent has been flagged as 'deleted'! Skipping event listener...");
                return event;
            }
            log.debug("Sending notification to {} event listeners.", (Object)this.eventListener.size());
            for (EventListener eventListener : this.eventListener) {
                try {
                    long t0 = System.currentTimeMillis();
                    eventListener.eventArrived(event);
                    long t1 = System.currentTimeMillis();
                    log.debug("Listener {} required {} ms", (Object)eventListener, (Object)(t1 - t0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String string : context.keySet()) {
                Object o = context.get(string);
                if (!(o instanceof Runnable)) continue;
                log.debug("Need to execute trigger {} ({})", (Object)string, o);
            }
            return event;
        }
        catch (Exception e) {
            log.error("Failed to process event {}: {}", (Object)event, (Object)e.getMessage());
            e.printStackTrace();
            return event;
        }
    }

    public void unregisterEventProcessor(EventProcessor<AuditEvent> p) {
        log.debug("Unregistering event-processor {} with priority {}", p, (Object)this.priorities.get(p.toString()));
        this.eventProcessors.remove(p);
        this.priorities.remove(p);
    }

    public void unregisterListener(EventListener<AuditEvent> l) {
        log.debug("Unregistering event-listener {}", l);
        this.eventListener.remove(l);
        log.debug("EventListener queue now is:");
        for (EventListener<AuditEvent> proc : this.eventListener) {
            log.debug("   {}", proc);
        }
    }

    public void registerListener(EventListener<AuditEvent> l) {
        log.debug("Registering event-listener {}", l);
        this.eventListener.add(l);
        log.debug("EventListener queue now is:");
        for (EventListener<AuditEvent> proc : this.eventListener) {
            log.debug("   {}", proc);
        }
    }

    public void logInfo() {
        log.info("Processor queue:");
        for (EventProcessor eventProcessor : this.eventProcessors) {
            log.info("   {}", (Object)eventProcessor);
        }
        log.info("EventListener queue:");
        for (EventListener eventListener : this.eventListener) {
            log.info("   {}", (Object)eventListener);
        }
    }

    @Override
    public void process(AuditEvent event) throws EventProcessorException {
        this.processEvent(event);
    }

    public List<EventProcessor<AuditEvent>> getProcessors() {
        return Collections.unmodifiableList(this.eventProcessors);
    }

    public List<EventListener<AuditEvent>> getListeners() {
        ArrayList<EventListener<AuditEvent>> listener = new ArrayList<EventListener<AuditEvent>>(this.eventListener);
        return Collections.unmodifiableList(listener);
    }

    @Override
    public void unregister(EventProcessor<AuditEvent> proc) {
        this.eventProcessors.remove(proc);
    }

    @Override
    public void register(Double priority, EventProcessor<AuditEvent> proc) {
        this.eventProcessors.add(proc);
        this.priorities.put(proc, priority);
        Collections.sort(this.eventProcessors, new Priority(this.priorities));
        log.debug("Registering processor {} with priority {}", proc, (Object)priority);
        log.debug("Processor queue now is:");
        for (EventProcessor eventProcessor : this.eventProcessors) {
            log.debug("   {}   (prio: {})", (Object)eventProcessor, (Object)this.priorities.get(eventProcessor.toString()));
        }
    }

    @Override
    public Double getPriority(EventProcessor<AuditEvent> proc) {
        if (this.priorities.containsKey(proc)) {
            return this.priorities.get(proc);
        }
        return Double.NaN;
    }

    public class Priority
    implements Comparator<EventProcessor<AuditEvent>> {
        Map<EventProcessor<AuditEvent>, Double> prios = new HashMap<EventProcessor<AuditEvent>, Double>();

        public Priority(Map<EventProcessor<AuditEvent>, Double> p) {
            this.prios = p;
        }

        @Override
        public int compare(EventProcessor<AuditEvent> arg0, EventProcessor<AuditEvent> arg1) {
            int rc;
            Double p1;
            if (arg0 == arg1) {
                return 0;
            }
            Double p0 = this.prios.get(arg0);
            if (p0 == null) {
                p0 = DEFAULT_PRIORITY;
            }
            if ((p1 = this.prios.get(arg1)) == null) {
                p1 = DEFAULT_PRIORITY;
            }
            if ((rc = p0.compareTo(p1)) == 0) {
                return arg0.toString().compareTo(arg1.toString());
            }
            return rc;
        }
    }
}

