/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XForwardedForResolver
implements EventProcessor<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(XForwardedForResolver.class);
    public static String X_FORWARDED_FOR = "REQUEST_HEADERS" + ":X-Forwarded-For".toUpperCase();

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        String forwardedFor = event.get(X_FORWARDED_FOR);
        if (forwardedFor != null && !forwardedFor.trim().equals("")) {
            log.debug("Found X-Forwarded-For header, value: {}", (Object)forwardedFor);
            event.set("REMOTE_ADDR", forwardedFor);
        }
        return event;
    }
}

