/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jwall.audit.FeatureExtractor;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.ModSecurity;
import org.jwall.web.audit.io.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExtractor
implements FeatureExtractor<AuditEvent, List<String>> {
    static Logger log = LoggerFactory.getLogger(ValueExtractor.class);
    static final ValueExtractor extractor = new ValueExtractor();
    final Set<String> needsParsing = new HashSet<String>();
    final Set<String> variables = new LinkedHashSet<String>();
    final Map<String, FeatureExtractor<AuditEvent, ?>> extractors = new LinkedHashMap();

    protected ValueExtractor() {
        for (String var : ModSecurity.VARIABLES) {
            this.variables.add(var);
        }
        for (String var : AuditEvent.VARIABLES) {
            this.variables.add(var);
        }
        this.needsParsing.add("RULE_SEV");
        this.needsParsing.add("RULE_MSG");
        this.needsParsing.add("RULE_TAG");
        this.needsParsing.add("RULE_ID");
        this.needsParsing.add("RULE_DATA");
        this.needsParsing.add("HIGHEST_SEVERITY");
        this.needsParsing.add("LOWEST_SEVERITY");
        this.needsParsing.add("SEVERITY");
        this.needsParsing.add("MESSAGE");
    }

    public void registerExtractor(String name, FeatureExtractor<AuditEvent, ?> extr) {
        if (this.extractors.containsKey(name)) {
            log.warn("Overriding existing feature-extractor '{}'", this.extractors.get(name));
        }
        log.debug("Adding extractor '{}' for feature {}", extr, (Object)name);
        this.extractors.put(name, extr);
    }

    @Override
    public Set<String> getVariables(AuditEvent event) {
        return this.variables;
    }

    @Override
    public List<String> extract(String variable, AuditEvent evt) {
        List<String> values = new LinkedList<String>();
        if (variable.startsWith("&")) {
            log.debug("Extracting special variable '{}', which refers to value-counting", (Object)variable);
            Integer count = new Integer(evt.getAll(variable.substring(1)).size());
            values.add(count.toString());
            log.debug("  => Result is '{}'", values);
            return values;
        }
        if ("AGE".equals(variable)) {
            Date d = evt.getDate();
            if (d == null) {
                values.add(Long.toString(System.currentTimeMillis()));
            } else {
                values.add(Long.toString(System.currentTimeMillis() - d.getTime()));
            }
            return values;
        }
        if (this.extractors.containsKey(variable)) {
            FeatureExtractor<AuditEvent, ?> extractor = this.extractors.get(variable);
            Object feature = extractor.extract(variable, evt);
            if (feature instanceof Collection) {
                Collection fs = (Collection)feature;
                for (Object o : fs) {
                    values.add(o.toString());
                }
            } else {
                values.add(feature.toString());
            }
            return values;
        }
        if (this.needsMessageParsing(variable)) {
            log.debug("   need to parse event details");
            try {
                List<AuditEventMessage> msgs = MessageParser.parseMessages(evt);
                for (AuditEventMessage msg : msgs) {
                    log.debug("Processing event-message: {}", (Object)msg.toString());
                    if (("RULE_SEV".equals(variable) || "SEVERITY".equals(variable)) && msg.getSeverity() != null && msg.getSeverity() > 0 && msg.getSeverity() != 15) {
                        values.add(msg.getSeverity().toString());
                    }
                    if ("RULE_MSG".equals(variable) && msg.getRuleMsg() != null) {
                        values.add(msg.getRuleMsg());
                    }
                    if ("RULE_ID".equals(variable) && msg.getRuleId() != null) {
                        values.add(msg.getRuleId().toString());
                    }
                    if ("RULE_TAG".equals(variable) && msg.getRuleTags() != null) {
                        values.addAll(msg.getRuleTags());
                    }
                    if ("RULE_FILE".equals(variable) && msg.getFile() != null) {
                        values.add(msg.getFile());
                    }
                    if ("RULE_DATA".equals(variable) && msg.getRuleData() != null) {
                        values.add(msg.getRuleData());
                    }
                    if (!"MESSAGE".equals(variable) || msg.getText() == null) continue;
                    values.add(msg.getText());
                }
                if ("SEVERITY".equals(variable) && values.isEmpty()) {
                    values.add("255");
                }
                log.debug("Extracted values for '{}': {}", (Object)variable, values);
                return values;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new LinkedList<String>();
            }
        }
        values = evt.getAll(variable);
        log.debug("Extracted values for '{}': {}", (Object)variable, values);
        return values;
    }

    private boolean needsMessageParsing(String variable) {
        return this.needsParsing.contains(variable);
    }

    public static List<String> extractValues(String variable, AuditEvent evt) {
        return extractor.extract(variable, evt);
    }
}

