/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules.operators;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.List;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.ValueExtractor;
import org.jwall.web.audit.rules.operators.BeginsWith;
import org.jwall.web.audit.rules.operators.ConditionEQ;
import org.jwall.web.audit.rules.operators.ConditionGE;
import org.jwall.web.audit.rules.operators.ConditionGT;
import org.jwall.web.audit.rules.operators.ConditionIN;
import org.jwall.web.audit.rules.operators.ConditionLE;
import org.jwall.web.audit.rules.operators.ConditionLT;
import org.jwall.web.audit.rules.operators.ConditionPM;
import org.jwall.web.audit.rules.operators.ConditionRX;
import org.jwall.web.audit.rules.operators.ConditionSX;
import org.jwall.web.audit.rules.operators.Contains;
import org.jwall.web.audit.rules.operators.EndsWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCondition
implements Condition {
    private static final long serialVersionUID = 1950679429132740380L;
    static Logger log = LoggerFactory.getLogger(AbstractCondition.class);
    @XStreamAlias(value="variable")
    @XStreamAsAttribute
    String variable;
    @XStreamAlias(value="value")
    @XStreamAsAttribute
    String value;

    public AbstractCondition(String variable, String value) throws SyntaxException {
        this.variable = variable;
        this.value = value;
        if (this.variable == null) {
            throw new SyntaxException("Variable must not be null!");
        }
        if (this.value == null) {
            throw new SyntaxException("Value for condition must not be null!");
        }
    }

    public List<String> extractValues(AuditEvent evt) {
        List<String> values = ValueExtractor.extractValues(this.getVariable(), evt);
        return values;
    }

    @Override
    public final boolean matches(AuditEvent evt) {
        List<String> values = this.extractValues(evt);
        return this.matches(values);
    }

    public final boolean matches(List<String> values) {
        for (String val : values) {
            if (this.isNegated() || !this.matches(val)) continue;
            return true;
        }
        return false;
    }

    public final boolean matches(String val) {
        if (this.isNegated()) {
            return !this.matches(this.getPureValue(), val);
        }
        return this.matches(this.getPureValue(), val);
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.getVariable() + " " + this.getOperator() + " " + this.getValue();
    }

    public final String getPureValue() {
        if (this.value != null && this.value.startsWith("!")) {
            return this.value.substring(1);
        }
        return this.value;
    }

    public final boolean isNegated() {
        return this.value != null && this.value.startsWith("!");
    }

    public static boolean isNumeric(String s) {
        try {
            String str = s;
            if (str.startsWith("!")) {
                str = str.substring(1);
            }
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public abstract String getOperator();

    public static Condition createCondition(Operator oper, String variable, String value) throws SyntaxException {
        switch (oper) {
            case RX: {
                return new ConditionRX(variable, value);
            }
            case EQ: {
                return new ConditionEQ(variable, value);
            }
            case LT: {
                return new ConditionLT(variable, value);
            }
            case LE: {
                return new ConditionLE(variable, value);
            }
            case GT: {
                return new ConditionGT(variable, value);
            }
            case GE: {
                return new ConditionGE(variable, value);
            }
            case PM: {
                return new ConditionPM(variable, value);
            }
            case SX: {
                return new ConditionSX(variable, value);
            }
            case BeginsWith: {
                return new BeginsWith(variable, value);
            }
            case EndsWith: {
                return new EndsWith(variable, value);
            }
            case Contains: {
                return new Contains(variable, value);
            }
            case IN: {
                return new ConditionIN(variable, value);
            }
        }
        throw new SyntaxException("Operator not supported!");
    }
}

