/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpander {
    static Logger log = LoggerFactory.getLogger(MacroExpander.class);
    public static final String VAR_PREFIX = "%{";
    public static final String VAR_SUFFIX = "}";
    Map<String, String> variables = new HashMap<String, String>();

    public MacroExpander() {
        this(new HashMap<String, String>());
    }

    public MacroExpander(Map<String, String> variables) {
        this.variables = variables;
    }

    public MacroExpander(Properties p) {
        this.variables = new HashMap<String, String>();
        for (Object k : p.keySet()) {
            this.variables.put(k.toString(), p.getProperty(k.toString()));
        }
    }

    public void addVariables(Map<String, String> vars) {
        for (String key : vars.keySet()) {
            this.variables.put(key, vars.get(key));
        }
    }

    public void set(String key, String val) {
        this.variables.put(key, val);
    }

    public String expand(String str, AuditEvent evt) {
        return this.substitute(str, evt);
    }

    protected String substitute(String str, AuditEvent evt) {
        String content = str;
        int start = content.indexOf(VAR_PREFIX, 0);
        while (start >= 0) {
            int end = content.indexOf(VAR_SUFFIX, start);
            if (end >= start + 2) {
                String variable = content.substring(start + 2, end);
                log.debug("Found variable: {}", (Object)variable);
                log.trace("   content is: {}", (Object)content);
                String val = this.get(variable, evt);
                content = val != null ? content.substring(0, start) + val + content.substring(end + 1) : content.substring(0, start) + "" + content.substring(end + 1);
                if (end < content.length()) {
                    start = content.indexOf(VAR_PREFIX, end);
                    continue;
                }
                start = -1;
                continue;
            }
            start = -1;
        }
        return content;
    }

    public String get(String variable, AuditEvent evt) {
        String str;
        if (evt != null && (str = evt.get(variable)) != null) {
            return str;
        }
        return this.variables.get(variable);
    }

    public static String expand(String string, Map<String, String> vars) {
        MacroExpander expander = new MacroExpander(vars);
        return expander.substitute(string, null);
    }
}

