/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http;

import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Set;
import org.jwall.web.http.MessageFormatException;

public class HttpHeader {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String SP = " ";
    public static final String CRLF = "\r\n";
    public static final String HEADER_FIELD_SEPARATOR = ":\\s*";
    public static final ByteBuffer CRLF_BUF = ByteBuffer.wrap(new byte[]{13, 10});
    public static boolean CASE_INSENSITIVE_HEADERS = true;
    public static final String CONNECTION = "Connection".toLowerCase();
    public static final String DATE = "Date".toLowerCase();
    public static final String PRAGMA = "Pragma".toLowerCase();
    public static final String TRAILER = "Trailer".toLowerCase();
    public static final String TRANSFER_ENCODING = "Transfer-Encoding".toLowerCase();
    public static final String UPGRADE = "Upgrade".toLowerCase();
    public static final String VIA = "Via".toLowerCase();
    public static final String WARNING = "Warning".toLowerCase();
    public static final String CACHE_CONTROL = "Cache-Control".toLowerCase();
    public static final String ALLOW = "Allow".toLowerCase();
    public static final String CONTENT_ENCODING = "Content-Encoding".toLowerCase();
    public static final String CONTENT_LANGUAGE = "Content-Language".toLowerCase();
    public static final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    public static final String CONTENT_LOCATION = "Content-Location".toLowerCase();
    public static final String CONTENT_MD5 = "Content-MD5".toLowerCase();
    public static final String CONTENT_RANGE = "Content-Range".toLowerCase();
    public static final String CONTENT_TYPE = "Content-Type".toLowerCase();
    public static final String EXPIRES = "Expires".toLowerCase();
    public static final String LAST_MODIFIED = "Last-Modified".toLowerCase();
    String header = null;
    String startLine = null;
    private Hashtable<String, String> headers;

    public HttpHeader(String head) throws MessageFormatException {
        this.header = head;
        this.headers = this.parseHeader(this.header);
    }

    public Hashtable<String, String> parseHeader(String s) throws MessageFormatException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String line = null;
        String[] lines = s.trim().split(CRLF);
        try {
            line = this.startLine = lines[0];
        }
        catch (Exception e) {
            throw new MessageFormatException("Invalid message format: " + s);
        }
        for (int j = 1; j < lines.length; ++j) {
            String[] tok = lines[j].split(HEADER_FIELD_SEPARATOR, 2);
            if (tok.length != 2) {
                throw new MessageFormatException("Invalid header-line: " + line);
            }
            if (CASE_INSENSITIVE_HEADERS) {
                ht.put(tok[0].toLowerCase(), tok[1]);
                continue;
            }
            ht.put(tok[0], tok[1]);
        }
        return ht;
    }

    public String getHeader() {
        return this.header;
    }

    public String getHeader(String hn) {
        if (CASE_INSENSITIVE_HEADERS) {
            return this.headers.get(hn.toLowerCase());
        }
        return this.headers.get(hn);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String debugString() {
        StringBuffer s = new StringBuffer("\t" + this.startLine + "\n");
        for (String k : this.headers.keySet()) {
            s.append("\t" + k + " -> " + this.headers.get(k) + "\n");
        }
        return s.toString();
    }

    public Integer getContentLength() {
        String cl = this.getHeader(CONTENT_LENGTH);
        if (cl != null) {
            return new Integer(cl.trim());
        }
        return -1;
    }

    public boolean isChunked() {
        String te = this.getHeader(TRANSFER_ENCODING);
        return te != null && !te.trim().equals("identity");
    }

    public boolean isConnectionCloseSet() {
        String con = this.getHeader(CONNECTION);
        return con != null && con.indexOf("close") >= 0;
    }
}

