/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jwall.audit.EventType;
import org.jwall.log.LogMessage;
import org.jwall.log.LogMessageImpl;
import org.jwall.log.io.GenericLogParser;
import org.jwall.log.io.MParser;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogParser
extends GenericLogParser {
    private static final long serialVersionUID = 2784731722816969735L;
    public static final String DATE_FORMAT = "[EEE MMM dd HH:mm:ss yyyy]";
    public static final String DATE_PATTERN = "\\[(.*?)\\]";
    static Logger log = LoggerFactory.getLogger(ErrorLogParser.class);
    DateFormat fmt = new SimpleDateFormat("[EEE MMM dd HH:mm:ss yyyy]", Locale.ENGLISH);

    @Override
    public LogMessage parse(String line) throws ParseException {
        if (line == null) {
            return null;
        }
        Long time = 0L;
        MParser p = new MParser();
        String dt = p.readToken(line);
        try {
            Date d = this.fmt.parse(dt.trim());
            time = d.getTime();
        }
        catch (Exception e) {
            log.error("Failed to parse date '{}' with format-pattern {}", (Object)dt.trim(), (Object)DATE_FORMAT);
            e.printStackTrace();
            time = 0L;
        }
        LogMessageImpl msg = new LogMessageImpl(EventType.ERROR, time, "", line);
        log.debug("Adding defaults {}", (Object)this.defaultValues);
        for (String key : this.defaultValues.keySet()) {
            String val = (String)this.defaultValues.get(key);
            log.debug("Adding default value '{}' = '{}'", (Object)key, (Object)val);
            msg.set(key, val);
        }
        return msg;
    }

    public static void main(String[] args) throws Exception {
        String s = "[Fri Nov 20 21:40:42 2009]";
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        System.out.println("DATE_FORMAT = [EEE MMM dd HH:mm:ss yyyy]");
        System.out.println("fmt = " + fmt.toString());
        System.out.println(s + "  parses to: " + fmt.parse(s));
    }
}

