/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jwall.log.io.GenericParser;
import org.jwall.log.io.Parser;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserGenerator {
    static Logger log = LoggerFactory.getLogger(ParserGenerator.class);
    String grammar;

    public ParserGenerator(String grammar) {
        this.grammar = grammar;
    }

    public Map<String, String> parse(String str) throws ParseException {
        return this.newParser().parse(str);
    }

    public Parser<Map<String, String>> newParser() {
        return this.create(this.grammar);
    }

    public List<String> parseGrammar(String grammar) {
        ArrayList<String> toks = new ArrayList<String>();
        int off = 0;
        for (int i = 0; i < grammar.length(); ++i) {
            log.debug("Parsing grammar: '{}'", (Object)grammar.substring(i));
            if (grammar.startsWith("%{", i)) {
                int end;
                if (i > off) {
                    String con = grammar.substring(off, i);
                    log.debug("adding constant {}", (Object)con);
                    toks.add(con);
                }
                if ((end = grammar.indexOf("}", i + 1)) < i) continue;
                String var = grammar.substring(i, end + 1);
                log.debug("Found variable {}", (Object)var);
                toks.add(var);
                off = end + 1;
                i += var.length() - 1;
                continue;
            }
            if (grammar.indexOf("%{", i) >= 0) continue;
            log.debug("Found no more variables, treating remainder string as constant token!");
            toks.add(grammar.substring(i));
            return toks;
        }
        return toks;
    }

    public Parser<Map<String, String>> create(String grammarDefinition) {
        ArrayList<Token> tokenDefs = new ArrayList<Token>();
        List<String> tokens = this.parseGrammar(grammarDefinition);
        log.info("Grammar tokens: {}", tokens);
        for (String toks : tokens) {
            tokenDefs.add(new Token(toks));
        }
        return new GenericParser(tokenDefs);
    }

    public boolean isVariableToken(String str) {
        boolean var = str != null && str.startsWith("%{") && str.endsWith("}");
        log.debug("isVariableToken( {} ) = {} ", (Object)str, (Object)var);
        return var;
    }

    public static class Token {
        String value;
        Pattern pattern;

        public Token(String name) {
            this.value = name;
            if (!name.startsWith("%{")) {
                try {
                    log.debug("trying to treat '{}' as regular expression", (Object)name);
                    this.pattern = Pattern.compile(name);
                }
                catch (Exception exception) {}
            } else {
                try {
                    int idx = name.indexOf("|");
                    int end = name.lastIndexOf("}");
                    if (idx >= 0 && end > idx) {
                        this.pattern = Pattern.compile(name.substring(idx + 1, end));
                    }
                    log.debug("Created regex-token with regex = '{}'", (Object)this.pattern);
                }
                catch (Exception e) {
                    log.debug("Failed to compile pattern: {}", (Object)e.getMessage());
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    this.pattern = null;
                }
            }
        }

        public boolean isRegex() {
            return this.pattern != null;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isVariable() {
            return this.value != null && this.value.startsWith("%{") && this.value.endsWith("}");
        }

        public String getName() {
            if (this.isVariable()) {
                String str = this.value.substring(2, this.value.length() - 1);
                if (str.indexOf("|") > 0) {
                    return str.substring(0, str.indexOf("|"));
                }
                return str;
            }
            return this.value;
        }

        public int skipLength(String str) {
            if (this.isRegex()) {
                log.debug("Checking skip-length for pattern '{}' on string {}", (Object)this.pattern.toString(), (Object)str);
                Matcher matcher = this.pattern.matcher(str);
                if (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    log.debug("checking string '{}'", (Object)str);
                    String val = str.substring(start, end);
                    log.debug("substring '{}' matches {}", (Object)val, (Object)this.pattern);
                    return val.length();
                }
            }
            return this.value.length();
        }

        public String getValue() {
            return this.value;
        }
    }
}

