/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.IOException;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.AuditEventQueue;
import org.jwall.web.audit.io.AuditEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventDispatcher
extends Thread {
    public static final int READER_WAITING_TIME = 256;
    private static Logger log = LoggerFactory.getLogger((String)"AuditEventDispatcher");
    private AuditEventReader source;
    private Queue<AuditEventListener> listener;
    int eventsDispatched = 0;
    AuditEventQueue buffer = null;
    boolean running = true;
    boolean persistent = true;

    public AuditEventDispatcher() {
        this.buffer = new AuditEventQueue();
        this.source = null;
        this.listener = new LinkedBlockingQueue<AuditEventListener>();
    }

    public AuditEventDispatcher(AuditEventReader src) {
        this.source = src;
        this.listener = new LinkedBlockingQueue<AuditEventListener>();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void add(AuditEvent evt) {
        this.dispatchEvent(evt);
    }

    public void enqueueEvent(AuditEvent evt) {
        if (this.buffer != null) {
            this.buffer.eventArrived(evt);
        } else {
            this.dispatchEvent(evt);
        }
    }

    public void addAuditEventListener(AuditEventListener listener) {
        this.listener.add(listener);
    }

    public void removeAuditEventListener(AuditEventListener listener) {
        this.listener.remove(listener);
    }

    public void removeAuditEventListeners() {
        this.listener.clear();
    }

    public Collection<AuditEventListener> getAuditEventListeners() {
        return this.listener;
    }

    private void dispatchEvent(AuditEvent evt) {
        if (evt == null) {
            return;
        }
        log.debug("AuditEventDispatcher: Notifying listeners...");
        for (AuditEventListener l : this.listener) {
            l.eventArrived(evt);
        }
        ++this.eventsDispatched;
    }

    @Override
    public void run() {
        while (this.running) {
            AuditEvent evt = null;
            while (evt == null) {
                try {
                    log.debug("AuditEventDispatcher: waiting for next event from source {}", (Object)this.source);
                    evt = this.source.readNext();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    evt = null;
                }
                if (evt == null) {
                    if (this.persistent) {
                        log.debug("Dispatcher in persistent mode...");
                        try {
                            Thread.sleep(256L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    log.debug("Dispatcher in non-persistent mode... shutting down...");
                    this.running = false;
                    break;
                }
                log.debug("ScriptEvent read, now dispatching it .... ");
            }
            this.dispatchEvent(evt);
        }
    }

    public int getNumberOfEvents() {
        return this.eventsDispatched;
    }

    public void close() throws IOException {
        this.running = false;
        if (this.source != null) {
            this.source.close();
        }
    }
}

