/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.net.SyslogAuditEventStream;
import org.jwall.web.audit.net.SyslogReceiverThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventStreamHandler
extends Thread
implements AuditEventListener {
    static Logger log = LoggerFactory.getLogger(AuditEventStreamHandler.class);
    Long start;
    Integer count = 0;
    Socket socket;
    static final DecimalFormat fmt = new DecimalFormat("0.00");
    SyslogReceiverThread parent;
    boolean gzip = false;
    ArrayList<AuditEventListener> listener = new ArrayList();
    boolean running = true;
    boolean base64 = false;

    public AuditEventStreamHandler(SyslogReceiverThread parent, Socket socket, boolean gzip, boolean base64) throws Exception {
        this.parent = parent;
        this.socket = socket;
        this.gzip = gzip;
        File outFile = new File(File.separator + "tmp" + File.separator + socket.getInetAddress().getHostAddress() + "-" + socket.getPort() + "-audit.log");
        log.debug("Writing to {}", (Object)outFile);
        this.setDaemon(true);
    }

    public void addListener(AuditEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    @Override
    public void run() {
        try {
            log.info("Starting event-stream from connection {}", (Object)this.socket.getInetAddress());
            this.start = System.currentTimeMillis();
            InputStream in = this.socket.getInputStream();
            SyslogAuditEventStream reader = new SyslogAuditEventStream(in, (AuditEventListener)this);
            AuditEvent evt = reader.readNext();
            while (this.running && evt != null && !this.socket.isClosed()) {
                this.eventArrived(evt);
                evt = reader.readNext();
            }
            log.info("Connection closed.");
        }
        catch (EOFException eof) {
            log.info("Connection closed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.parent != null) {
            this.parent.handlerFinished(this);
        }
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        try {
            for (AuditEventListener l : this.listener) {
                l.eventArrived(evt);
            }
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
            if (this.count % 100 == 0) {
                Long time = System.currentTimeMillis() - this.start;
                log.info(this.count + " events received in " + (int)(time / 1000L) + " seconds (" + fmt.format(1000.0 * this.count.doubleValue() / time.doubleValue()) + " events/second)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent e : events) {
            this.eventArrived(e);
        }
    }

    public void close() {
        try {
            log.info("Closing connection {}:{}", (Object)this.socket.getInetAddress(), (Object)this.socket.getPort());
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
        this.interrupt();
    }
}

