/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.HttpMessage;
import org.jwall.web.http.MessageFormatException;
import org.jwall.web.http.ProtocolException;
import org.jwall.web.http.nio.HttpResponseChannel;

public class HttpResponse
extends HttpMessage {
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String AGE = "Age";
    public static final String ETAG = "ETag";
    public static final String LOCATION = "Location";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String VARY = "Vary";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    String msg = null;
    Integer status = null;
    protected HttpResponseChannel channel = null;

    public HttpResponse(HttpHeader header, byte[] data) throws ProtocolException {
        super(header, data);
        this.parseStartLine(header.startLine);
    }

    public HttpResponse(String resHeader, byte[] responseData) throws ProtocolException {
        super(new HttpHeader(resHeader), responseData);
        this.parseStartLine(this.header.startLine);
    }

    public HttpResponse(String resHeader, byte[] responseData, HttpResponseChannel ch) throws ProtocolException {
        this(resHeader, responseData);
        this.channel = ch;
    }

    @Override
    protected void parseStartLine(String line) throws MessageFormatException {
        try {
            String[] token = line.split(" ", 3);
            this.version = token[0];
            this.status = Integer.valueOf(token[1]);
            this.msg = "";
            if (token.length > 2) {
                this.msg = token[2];
            }
        }
        catch (Exception e) {
            throw new MessageFormatException("Invalid status-line: " + line);
        }
    }

    public HttpResponseChannel getHttpStream() {
        return this.channel;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean isConnectionClosed() {
        return this.header.isConnectionCloseSet();
    }

    public boolean isChunked() {
        return this.header.isChunked();
    }

    public boolean isGZipped() {
        String ce = this.header.getHeader(HttpHeader.CONTENT_ENCODING);
        return ce != null && ce.indexOf("gzip") >= 0;
    }

    public String getCharset() {
        String[] tok;
        String s = this.getHeader(HttpHeader.CONTENT_TYPE);
        if (s == null) {
            return "UTF-8";
        }
        for (String ch : tok = s.split(";")) {
            if (!ch.startsWith("charset=")) continue;
            return ch.substring("charset=".length()).trim();
        }
        return "UTF-8";
    }

    public String getContentType() {
        String s = this.getHeader(HttpHeader.CONTENT_TYPE);
        if (s != null) {
            String[] tok = s.split(";");
            return tok[0].trim();
        }
        return "";
    }

    public String getPayload() {
        try {
            Charset cs = Charset.forName(this.getCharset());
            CharsetDecoder decoder = cs.newDecoder();
            CharBuffer cb = decoder.decode(this.body);
            return cb.toString();
        }
        catch (Exception e) {
            return new String(this.body.array());
        }
    }

    public void setBody(ByteBuffer body) {
        this.body = body;
    }

    public void setChannel(HttpResponseChannel ch) {
        this.channel = ch;
    }

    public HttpResponseChannel getChannel() {
        return this.channel;
    }

    public boolean isChunk() {
        return false;
    }
}

