package org.jwall.web.audit.util;

import java.util.HashMap;
import java.util.Map;

import stream.ProcessContext;
import stream.service.Service;

public class ProcessContextImpl implements ProcessContext {

	final Map<String, Service> services = new HashMap<String, Service>();
	final Map<String, Object> objects = new HashMap<String, Object>();

	@Override
	public Object resolve(String variable) {
		return objects.get(variable);
	}

	@Override
	public Service lookup(String ref) throws Exception {
		return services.get(ref);
	}

	@Override
	public void register(String ref, Service p) throws Exception {
		services.put(ref, p);
	}

	@Override
	public void unregister(String ref) throws Exception {
		services.remove(ref);
	}

	@Override
	public Object get(String key) {
		return objects.get(key);
	}

	@Override
	public void set(String key, Object o) {
		objects.put(key, o);
	}
}
