/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.filter.BooleanOperator;
import org.jwall.web.audit.filter.FilterException;
import org.jwall.web.audit.filter.FilterExpression;
import org.jwall.web.audit.filter.FilterExpressionList;
import org.jwall.web.audit.filter.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionReader {
    int pos = 0;
    String input;
    Set<Operator> supportedOperators = new HashSet<Operator>();
    Set<BooleanOperator> supportedBoolOperators = new HashSet<BooleanOperator>();
    Set<String> supportedVariables = null;
    public static final boolean STRICT_PARSING = "true".equalsIgnoreCase("" + System.getProperty("event.filter.strict"));
    static Logger log = LoggerFactory.getLogger(ExpressionReader.class);
    boolean strictParsing = STRICT_PARSING;

    protected ExpressionReader(String str) {
        this.input = str;
        this.pos = 0;
        this.supportedBoolOperators.add(BooleanOperator.AND);
        this.supportedBoolOperators.add(BooleanOperator.OR);
        for (Operator op : Operator.values()) {
            this.supportedOperators.add(op);
        }
    }

    protected ExpressionReader(String str, Collection<String> variables) {
        this(str);
        this.supportedVariables = new HashSet<String>();
        for (String var : variables) {
            this.supportedVariables.add(var.toUpperCase());
        }
    }

    protected ExpressionReader(String str, Collection<String> variables, Set<Operator> operators) {
        this(str, variables);
        this.supportedOperators.clear();
        this.supportedOperators.addAll(operators);
    }

    public boolean isStrictParsing() {
        return this.strictParsing;
    }

    public void setStrictParsing(boolean strictParsing) {
        this.strictParsing = strictParsing;
    }

    public void setBooleanOperators(Set<BooleanOperator> booleanOps) {
        this.supportedBoolOperators = new HashSet<BooleanOperator>(booleanOps);
    }

    public Set<BooleanOperator> getBooleanOperators() {
        return this.supportedBoolOperators;
    }

    protected FilterExpression readFilterExpression() throws FilterException {
        this.skipWhiteSpace();
        if (this.startsWith("(")) {
            log.debug("Found nested expression at pos {}: {}", (Object)this.pos, (Object)this.input.substring(this.pos));
            FilterExpressionList list = this.readNestedExpression();
            log.debug("\nnested expression: {}\n\n", (Object)list.toString());
            return list;
        }
        FilterExpression first = this.readSimpleFilter();
        if (!(this.endOfLine() || this.hasBooleanOperator() || this.startsWith(")"))) {
            throw new FilterException("Boolean operator 'AND' or 'OR' expected after '" + this.input.substring(0, this.pos) + "'!");
        }
        if (this.endOfLine()) {
            return first;
        }
        ArrayList<FilterExpression> exps = new ArrayList<FilterExpression>();
        ArrayList<BooleanOperator> ops = new ArrayList<BooleanOperator>();
        exps.add(first);
        while (!this.endOfLine() && this.hasBooleanOperator()) {
            ops.add(this.readBooleanOperator());
            if (this.startsWith("(")) {
                exps.add(this.readNestedExpression());
                continue;
            }
            exps.add(this.readSimpleFilter());
        }
        log.debug("Ops: {}", ops);
        log.debug("Exps: {}", exps);
        if (exps.size() == 1) {
            return first;
        }
        return new FilterExpressionList((BooleanOperator)((Object)ops.iterator().next()), (Collection<FilterExpression>)exps);
    }

    public boolean endOfLine() {
        return this.pos >= this.input.length() || this.input.substring(this.pos).trim().equals("");
    }

    public FilterExpressionList readNestedExpression() throws FilterException {
        if (!this.startsWith("(")) {
            throw new FilterException("No start of nested expression found!");
        }
        this.skipWhiteSpace();
        ++this.pos;
        ArrayList<FilterExpression> exp = new ArrayList<FilterExpression>();
        exp.add(this.readFilterExpression());
        BooleanOperator op = null;
        while (!this.startsWith(")")) {
            if (this.endOfLine()) {
                throw new FilterException("Unexpected end of expression! Missing a closing bracket?");
            }
            op = this.readBooleanOperator();
            if (this.startsWith("(")) {
                exp.add(this.readNestedExpression());
                continue;
            }
            exp.add(this.readFilterExpression());
        }
        ++this.pos;
        return new FilterExpressionList(op, (Collection<FilterExpression>)exp);
    }

    public boolean startsWith(String str) {
        int i;
        for (i = this.pos; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        if (i >= this.input.length()) {
            return false;
        }
        return this.input.substring(i).startsWith(str);
    }

    public FilterExpression readSimpleFilter() throws FilterException {
        try {
            String var = this.readVariable();
            Operator op = this.readOperator();
            String value = this.readValue();
            return new AuditEventMatch(var, op, value);
        }
        catch (SyntaxException se) {
            throw new FilterException(se.getMessage());
        }
    }

    protected boolean hasBooleanOperator() {
        int i;
        for (i = this.pos; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        if (i >= this.input.length()) {
            return false;
        }
        String rest = this.input.substring(i);
        return rest.toLowerCase().startsWith("or ") || rest.toLowerCase().startsWith("and ");
    }

    protected BooleanOperator readBooleanOperator() throws FilterException {
        this.skipWhiteSpace();
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        String operatorName = var.toString();
        BooleanOperator op = BooleanOperator.read(operatorName);
        if (!this.supportedBoolOperators.contains((Object)op)) {
            if (this.isStrictParsing()) {
                throw new FilterException("Boolean operator '" + operatorName + "' is not supported!");
            }
            log.warn("Boolean operator '{}' is not supported, but 'strictParsing' is disabled!", (Object)operatorName);
        }
        return op;
    }

    public int getPosition() {
        return this.pos;
    }

    public String getInputString() {
        return this.input;
    }

    protected void skipWhiteSpace() {
        while (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
            ++this.pos;
        }
    }

    protected String readVariable() throws FilterException {
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        String variable = var.toString();
        if (this.supportedVariables != null && !this.supportedVariables.contains(variable.toUpperCase())) {
            if (this.isStrictParsing()) {
                throw new FilterException("Not a valid variable name '" + variable + "'!");
            }
            log.warn("Found variable '{}' which has not been defined previously!", (Object)variable);
        }
        return variable;
    }

    protected Operator readOperator() throws SyntaxException {
        this.skipWhiteSpace();
        if (this.pos >= this.input.length()) {
            throw new FilterException("Operator expected at position " + this.pos + ", found: '" + this.input.substring(this.pos) + "'!");
        }
        StringBuffer buf = new StringBuffer();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            buf.append(this.input.charAt(this.pos++));
        }
        Operator op = Operator.read(buf.toString());
        if (!this.supportedOperators.contains(op)) {
            if (this.isStrictParsing()) {
                throw new FilterException("Operator '" + op.toString() + "' not supported!");
            }
            log.warn("Operator '{}' is not supported, but 'strictParsing' disabled!", (Object)op);
        }
        return op;
    }

    protected String readValue() throws FilterException {
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        if (this.endOfLine() || this.startsWith(")") || this.hasBooleanOperator()) {
            throw new FilterException("Value expected at position " + this.pos + "!");
        }
        if (this.input.charAt(this.pos) == '\"' || this.input.charAt(this.pos) == '\'') {
            return this.readQuotedString(this.input.charAt(this.pos));
        }
        while (this.pos < this.input.length() && this.input.charAt(this.pos) != ')' && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        return var.toString();
    }

    protected String readQuotedString(char ch) {
        StringBuffer s = new StringBuffer();
        while (this.pos < this.input.length() && ch != this.input.charAt(this.pos)) {
            ++this.pos;
        }
        ++this.pos;
        if (this.pos < this.input.length()) {
            s.append(this.input.charAt(this.pos++));
        }
        int last = 32;
        while (this.pos < this.input.length() && last != 92 && ch != this.input.charAt(this.pos)) {
            char cur = this.input.charAt(this.pos++);
            s.append(cur);
            last = cur;
        }
        ++this.pos;
        return s.toString();
    }

    public static final FilterExpression parse(String str) throws FilterException {
        log.debug("Parsing expression: {}", (Object)str);
        ExpressionReader r = new ExpressionReader(str);
        return r.readFilterExpression();
    }
}

