/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.AuditServer;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.net.NetworkClientWorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Dispatcher
extends Thread {
    private static Logger log = LoggerFactory.getLogger((String)"Dispatcher");
    int clientPollTime = 0;
    boolean finished = false;
    BlockingQueue<AuditEvent> events;
    Queue<NetworkClientWorkerThread> worker;

    public Dispatcher(int clientIdleTime) {
        this.clientPollTime = clientIdleTime;
        this.events = new LinkedBlockingQueue<AuditEvent>();
        this.worker = new LinkedBlockingQueue<NetworkClientWorkerThread>();
    }

    @Override
    public void run() {
        while (!this.isFinished()) {
            try {
                while (this.events.isEmpty()) {
                    log.debug("NetworkEventServer.Dispatcher: Sleeping until events arrive...");
                    Thread.sleep(this.clientPollTime);
                }
                while (!this.events.isEmpty()) {
                    AuditEvent evt = (AuditEvent)this.events.poll();
                    for (NetworkClientWorkerThread t : this.worker) {
                        log.debug("Sending event to client...");
                        if (t.isAlive() && !t.isClosed()) {
                            t.eventArrived(evt);
                            continue;
                        }
                        t.closed = true;
                        this.worker.remove(t);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void enqueueEvents(AuditEvent evt) {
        this.events.add(evt);
    }

    public void unregisterClient(NetworkClientWorkerThread t) {
        if (this.worker.contains(t)) {
            this.worker.remove(t);
        }
    }

    public void registerClient(NetworkClientWorkerThread t) {
        log.debug("NetworkEventServer.Dispatcher: registering new client...");
        AuditServer.log("Client connected: " + t);
        this.worker.add(t);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finish() {
        this.finished = true;
    }
}

