/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jwall.audit.Event;
import org.jwall.audit.EventProcessor;
import org.jwall.audit.rules.EventRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventRuleEngine<E extends Event>
implements EventProcessor<E> {
    static Logger log = LoggerFactory.getLogger(EventRuleEngine.class);
    List<EventRule<E>> rules = new ArrayList<EventRule<E>>();

    public List<EventRule<E>> getRules() {
        return this.rules;
    }

    public void setRules(List<EventRule<E>> rules) {
        this.rules = rules;
    }

    @Override
    public final E processEvent(E event, Map<String, Object> context) throws Exception {
        List<EventRule<E>> rules = this.getRules();
        log.debug("Processing {} rules for event {}", (Object)rules.size(), event);
        for (EventRule<E> rule : rules) {
            if (rule.matches(event, null)) {
                log.debug("Rule {} matches, firing actions", rule);
                this.execute(rule, event, context);
                continue;
            }
            log.debug("Rule {} does not match", rule);
        }
        return event;
    }

    protected void execute(EventRule<E> rule, E event, Map<String, Object> context) {
        log.debug("Executing rule actions");
    }
}

