/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.io.AuditEventWriter;

public class ModSecurity2AuditWriter
implements AuditEventWriter {
    private PrintWriter writer;

    public ModSecurity2AuditWriter(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Cannot write to a directory!");
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot open file " + file.getAbsolutePath() + " for writing!");
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create file " + file.getAbsolutePath() + "!");
        }
        this.writer = new PrintWriter(new FileWriter(file));
    }

    @Override
    public void writeEvent(AuditEvent evt) throws IOException {
        for (int i = 0; i < "ABCDEFGHIJKTXZ".length(); ++i) {
            char sec = "ABCDEFGHIJKTXZ".charAt(i);
            String section = evt.getSection(i);
            if (section == null || "".equals(section.trim())) continue;
            this.writer.println("--" + evt.getEventId() + "-" + sec + "--");
            this.writer.print(section);
        }
        this.writer.println("--" + evt.getEventId() + "-Z--");
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }
}

