/*
 * Decompiled with CFR 0.152.
 */
package org.jwall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.jwall.web.audit.AuditEventDispatcher;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ConcurrentAuditReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.net.AuditEventConsoleSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collector {
    private static Logger log = LoggerFactory.getLogger((String)"Collector");
    public static final String COLLECTOR_SERIAL_LOG = "org.modsecurity.collector.serial-log";
    public static final String COLLECTOR_CONCURRENT_LOG = "org.modsecurity.collector.concurrent-log";
    public static final String COLLECTOR_CONCURRENT_INDEX = "org.modsecurity.collector.concurrent-index";
    public static final String COLLECTOR_SEND_COMPLETE_LOG = "org.modsecurity.collector.send-complete-log";
    public static final String COLLECTOR_CONSOLE_URL = "org.modsecurity.collector.url";
    public static final String COLLECTOR_CONSOLE_USER = "org.modsecurity.collector.user";
    public static final String COLLECTOR_CONSOLE_PASSWORD = "org.modsecurity.collector.password";
    public static final String VERSION = "0.2.17";
    public static Properties p = new Properties();
    static URL url = null;
    static String user;
    static String pass;
    public static final boolean DEBUG;

    public static AuditEventReader createAuditEventReader() throws Exception {
        boolean tail = true;
        if ("true".equals(p.getProperty(COLLECTOR_SEND_COMPLETE_LOG))) {
            System.err.println("Sending all audit-log entries!");
            tail = false;
        }
        AbstractAuditEventReader src = null;
        if ("stdin".equals(p.getProperty(COLLECTOR_SERIAL_LOG))) {
            System.out.println("Reading from standard input...");
            src = new ModSecurity2AuditReader(System.in, true);
            return src;
        }
        if (p.getProperty(COLLECTOR_SERIAL_LOG) != null) {
            String input = p.getProperty(COLLECTOR_SERIAL_LOG);
            if ("stdin".equalsIgnoreCase(input)) {
                System.out.println("Reading ModSecurity 2.x serial audit-log from standard input...");
                src = new ModSecurity2AuditReader(System.in);
                return src;
            }
            File f = new File(p.getProperty(COLLECTOR_SERIAL_LOG));
            if (!f.canRead()) {
                throw new Exception("Cannot open " + f.getAbsoluteFile() + " for reading!");
            }
            src = new ModSecurity2AuditReader(f, tail);
            return src;
        }
        if (p.getProperty(COLLECTOR_CONCURRENT_LOG) != null && p.getProperty(COLLECTOR_CONCURRENT_INDEX) != null) {
            String index = p.getProperty(COLLECTOR_CONCURRENT_INDEX);
            File dat = new File(p.getProperty(COLLECTOR_CONCURRENT_LOG));
            if (!dat.canRead()) {
                throw new Exception("Cannot open concurrent data-directory '" + dat.getAbsolutePath() + "' for reading!");
            }
            if ("stdin".equalsIgnoreCase(index)) {
                System.out.println("Reading summaries from standard input...");
                src = new ConcurrentAuditReader(System.in, dat);
            } else {
                File idx = new File(p.getProperty(COLLECTOR_CONCURRENT_INDEX));
                if (!idx.canRead()) {
                    throw new Exception("Cannot open concurrent index-file " + idx.getAbsoluteFile() + " for reading!");
                }
                src = new ConcurrentAuditReader(dat, idx, tail);
            }
        }
        return src;
    }

    public static boolean checkProperties(File pf) throws Exception {
        boolean ok = true;
        p = new Properties();
        File f = pf;
        if (f == null) {
            f = new File("sensor.properties");
        }
        if (!f.exists()) {
            URL url = new URL("https://localhost:8886/rpc/auditLogReceiver");
            p.setProperty(COLLECTOR_CONSOLE_USER, "test");
            p.setProperty(COLLECTOR_CONSOLE_PASSWORD, "sensor");
            p.setProperty(COLLECTOR_SERIAL_LOG, "/var/log/audit.log");
            p.setProperty(COLLECTOR_CONSOLE_URL, url.toString());
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            if (fileOutputStream != null) {
                p.store(fileOutputStream, "Automatically created initial config. Please edit for your needs!!");
                fileOutputStream.close();
            }
            log.info("Created default configuration in " + f.getAbsoluteFile() + "!");
            log.info("Please adjust config for your environment and restart.");
            System.exit(0);
        }
        if (!f.canRead()) {
            log.info("Properties file " + f.getAbsoluteFile() + " cannot be read!");
            ok = false;
        } else {
            log.debug("Reading properties from " + f.getAbsoluteFile());
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            if (fis != null) {
                p.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            log.error("Error while reading from " + f.getAbsoluteFile() + ": " + e.getMessage());
            ok = false;
        }
        for (String string : System.getProperties().keySet()) {
            if (!string.startsWith("org.modsecurity")) continue;
            p.setProperty(string, System.getProperty(string));
            log.info("Found system-property \"" + string + "\" = " + System.getProperty(string));
        }
        for (String string : p.keySet()) {
            System.err.println(" " + string + " = " + p.getProperty(string));
            if (!string.startsWith("org.modsecurity")) continue;
            log.debug("Property \"" + string + "\" = " + p.getProperty(string));
        }
        if (p.getProperty(COLLECTOR_CONSOLE_URL) == null) {
            throw new Exception("Property \"org.modsecurity.collector.url\" not found!");
        }
        url = new URL(p.getProperty(COLLECTOR_CONSOLE_URL));
        log.info("Found console url " + url);
        p.setProperty("org.modsecurity.console.host", url.getHost());
        p.setProperty("org.modsecurity.console.port", url.getPort() + "");
        p.setProperty("org.modsecurity.collector.ssl-enabled", url.getProtocol().toLowerCase().startsWith("https") + "");
        user = p.getProperty("org.modsecurity.console.user");
        if (user == null) {
            log.warn("Warning: No user-name specified, using default ('test').");
            user = "test";
        }
        if ((pass = p.getProperty("org.modsecurity.console.password")) == null) {
            log.warn("Warning: No password specified, using default ('sensor').");
            pass = "sensor";
        }
        Enumeration<Object> enumeration = p.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            log.debug(key + " = " + p.getProperty(key));
        }
        try {
            String ser = p.getProperty(COLLECTOR_SERIAL_LOG);
            String con = p.getProperty(COLLECTOR_CONCURRENT_LOG);
            String conIdx = p.getProperty(COLLECTOR_CONCURRENT_INDEX);
            if (ser == null) {
                log.debug("No serial-log specified.");
                if (con == null) {
                    log.debug("Warning: No concurrent auditlog specified!");
                }
                if (conIdx == null) {
                    log.debug("Warning: No concurrent auditlog index file specified!");
                }
            }
            if (ser == null && con == null && conIdx == null) {
                log.debug("Error: No audit-event-source specified!");
                throw new Exception("Missing audit-event-source!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ok;
    }

    public static String getProperty(String key) {
        return p.getProperty(key);
    }

    public static void main(String[] args) {
        try {
            int port;
            AuditEventReader src;
            File pf = null;
            if (args.length <= 0) {
                InputStream in = Collector.class.getResourceAsStream("/org/jwall/collector-usage.txt");
                if (in != null) {
                    BufferedReader r = new BufferedReader(new InputStreamReader(in));
                    String line = r.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = r.readLine();
                    }
                    r.close();
                } else {
                    System.out.println("\nSyntax error. Please see help for instructions on starting the collector!\n");
                }
                return;
            }
            pf = new File(args[0]);
            System.err.println("Reading settings from " + pf.getAbsolutePath());
            boolean ok = Collector.checkProperties(pf);
            if (!ok) {
                log.info("Error in configuration.");
            }
            if ((src = Collector.createAuditEventReader()) == null) {
                log.info("  Error: No valid audit-event-source specified!");
                log.info("  Error: Please check your config and try again.");
                System.exit(-1);
            }
            int n = port = url.getPort() > 0 ? url.getPort() : 8443;
            if (System.getProperty("DEBUG") != null) {
                log.info("Sending events to URL " + url.toString());
                log.info("   host = " + url.getHost());
                log.info("   port = " + port);
                log.info("   user = " + user);
                log.info("   pass = " + pass);
            }
            AuditEventConsoleSender sender = new AuditEventConsoleSender(url.getHost(), port, user, pass);
            AuditEventDispatcher d = new AuditEventDispatcher(src);
            d.setPersistent(!"true".equals(p.getProperty(COLLECTOR_SEND_COMPLETE_LOG)));
            d.addAuditEventListener(sender);
            d.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        try {
            new URL("https://localhost:8443/rpc/auditLogReceiver");
        }
        catch (Exception e) {
            log.info("Internal error: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        user = "test";
        pass = "sensor";
        DEBUG = System.getProperty("org.modsecurity.Collector.DEBUG") != null;
    }
}

