/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.processor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.util.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;

public class DNSLookup
extends AbstractProcessor
implements EventProcessor<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(DNSLookup.class);
    transient Cache<String> cache = new Cache(10000);
    transient Cache<String> reverseCache = new Cache(10000);
    String key = "REMOTE_HOST";
    String target = "REMOTE_HOSTNAME";
    Integer cacheSize = 10000;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new Cache(Math.max(100, cacheSize));
        this.reverseCache = new Cache(Math.max(100, cacheSize));
        log.debug("Created DNS cache of size {}", (Object)cacheSize);
    }

    public String reverseLookup(String addr) {
        String host = null;
        if (this.reverseCache != null && this.cacheSize > 0 && this.reverseCache.containsKey(addr)) {
            String hostname = this.reverseCache.get(addr);
            log.debug("Found cached host-name '{}' for addr {}", (Object)hostname, (Object)addr);
            return hostname;
        }
        if (addr != null && host == null) {
            try {
                InetAddress inet = InetAddress.getByName(addr);
                host = inet.getCanonicalHostName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return host;
    }

    public String lookup(String host) {
        String addr = null;
        if (this.cache != null && this.cacheSize > 0 && this.cache.containsKey(host)) {
            addr = this.cache.get(host);
            log.debug("Found cached address '{}' for host {}", (Object)addr, (Object)host);
            return addr;
        }
        if (host != null) {
            try {
                InetAddress inet = InetAddress.getByName(host);
                addr = inet.getHostAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return addr;
    }

    public Data process(Data data) {
        String name;
        Serializable addr = (Serializable)data.get((Object)this.key);
        if (addr != null && (name = this.reverseLookup(addr.toString())) != null) {
            data.put((Object)this.target, (Object)name);
        }
        return data;
    }

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        String addr = event.get(this.getKey());
        if (addr == null) {
            return event;
        }
        String hostname = this.reverseLookup(addr);
        if (hostname != null) {
            event.set(this.getTarget(), hostname);
        }
        return event;
    }
}

