/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSecurity2AuditStream
extends AbstractAuditEventReader
implements AuditEventReader,
Runnable {
    static Logger log = LoggerFactory.getLogger(ModSecurity2AuditReader.class);
    boolean tail;
    String prefix = null;
    String sensor = "";
    AuditEventListener listener;

    public ModSecurity2AuditStream(InputStream in, AuditEventListener listener) throws IOException {
        this(in, listener, true);
    }

    public ModSecurity2AuditStream(InputStream in, AuditEventListener listener, boolean persist) throws IOException {
        super(in);
        this.listener = listener;
        this.tail = persist;
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException, EOFException {
        ++this.counter;
        String line = this.readLine();
        long offset = (long)this.getDataRead();
        StringBuffer[] sections = new StringBuffer["ABCDEFGHIJKTXZ".length()];
        for (int i = 0; i < sections.length; ++i) {
            sections[i] = new StringBuffer();
        }
        int ptr = 0;
        try {
            while (!line.matches("--[\\-\\@0-9A-Za-z]*-A--")) {
                line = this.readLine();
                this.bytesRead += (double)line.length() + 1.0;
            }
            String id = line.replaceFirst("--", "").replaceAll("-A--", "");
            while (!line.startsWith("--") || !line.endsWith("-Z--")) {
                ptr = ModSecurity2AuditStream.getSectionIndex(line);
                line = this.readLine();
                this.bytesRead += (double)line.length() + 1.0;
                if (ptr >= 0) {
                    sections[ptr] = new StringBuffer();
                    do {
                        sections[ptr].append(line + "\n");
                        line = this.readLine();
                        this.bytesRead += (double)line.length();
                    } while (!line.trim().matches("^--.*-[A-Z]--$"));
                    continue;
                }
                log.debug("Line contains invalid section-name: " + line);
            }
            String[] data = new String["ABCDEFGHIJKTXZ".length()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = sections[i].toString();
            }
            if (data[0].equals("")) {
                return null;
            }
            AuditEvent event = this.eventFactory.createAuditEvent(id, data, this.inputFile, offset, (long)this.bytesRead - offset, AuditEventType.ModSecurity2);
            event.set("SENSOR_NAME", this.sensor);
            return event;
        }
        catch (EOFException eof) {
            System.out.println("End-of-file reached!");
            this.eofReached = true;
            throw eof;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException("End of file reached!");
        }
        if (this.prefix == "") {
            return line;
        }
        int idx = line.indexOf(": ");
        if (idx > 0) {
            int b;
            this.prefix = ": ";
            for (b = idx; b > 0 && line.charAt(b) != ' '; --b) {
            }
            this.sensor = line.substring(b, idx);
            return line.substring(idx + 2);
        }
        this.prefix = "";
        return line;
    }

    @Override
    public void run() {
        try {
            while (true) {
                AuditEvent event = this.readNext();
                this.listener.eventArrived(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

