/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.audit.EventProcessorException;
import org.jwall.audit.EventProcessorPipeline;
import org.jwall.log.LogMessage;

public class LogMessageProcessorPipeline
implements EventProcessorPipeline<LogMessage> {
    final Order<EventProcessor<LogMessage>> order = new Order();
    ArrayList<EventProcessor<LogMessage>> eventProcessors = new ArrayList();

    @Override
    public void process(LogMessage event) throws EventProcessorException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (EventProcessor<LogMessage> proc : this.eventProcessors) {
            try {
                proc.processEvent(event, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Double priority, EventProcessor<LogMessage> proc) {
        ArrayList<EventProcessor<LogMessage>> arrayList = this.eventProcessors;
        synchronized (arrayList) {
            this.order.set(proc, priority);
            this.eventProcessors.add(proc);
            Collections.sort(this.eventProcessors, this.order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(EventProcessor<LogMessage> proc) {
        ArrayList<EventProcessor<LogMessage>> arrayList = this.eventProcessors;
        synchronized (arrayList) {
            this.order.unset(proc);
            this.eventProcessors.remove(proc);
            Collections.sort(this.eventProcessors, this.order);
        }
    }

    @Override
    public Double getPriority(EventProcessor<LogMessage> proc) {
        return Double.NaN;
    }

    protected final class Order<T>
    implements Comparator<T> {
        Map<T, Double> prios;

        public Order() {
            this.prios = new HashMap<T, Double>();
        }

        public Order(Map<T, Double> prios) {
            this.prios = prios;
        }

        public void set(T key, Double prio) {
            this.prios.put(key, prio);
        }

        public void unset(T key) {
            this.prios.remove(key);
        }

        @Override
        public int compare(T arg0, T arg1) {
            if (arg0 == arg1 || arg0.equals(arg1)) {
                return 0;
            }
            Double p1 = this.prios.get(arg0);
            Double p2 = this.prios.get(arg1);
            if (p1 == null && p2 == null) {
                return -1;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            int rc = p1.compareTo(p2);
            if (rc == 0) {
                return arg0.toString().compareTo(arg1.toString());
            }
            return rc;
        }
    }
}

