/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jwall.audit.EventType;
import org.jwall.log.LogMessage;
import org.jwall.log.LogMessageImpl;
import org.jwall.log.io.GenericLogParser;
import org.jwall.log.io.MParser;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogParser
extends GenericLogParser {
    private static final long serialVersionUID = 3846739323473384809L;
    static Logger log = LoggerFactory.getLogger(AccessLogParser.class);
    DateFormat fmt = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]", Locale.US);

    @Override
    public LogMessage parse(String l) throws ParseException {
        Long time = 0L;
        MParser p = new MParser();
        String remoteAddress = p.readToken(l);
        String remoteUser = p.readToken(l);
        String unknown = p.readToken(l);
        String dt = p.readToken(l);
        if (dt != null) {
            dt = dt.trim();
        }
        try {
            Date date = this.fmt.parse(dt);
            time = date.getTime();
        }
        catch (Exception e) {
            log.error("Date format error for date-string '{}'? {}", (Object)dt, (Object)e.getMessage());
            e.printStackTrace();
            time = 0L;
        }
        LogMessageImpl msg = new LogMessageImpl(EventType.ACCESS, time, "", l);
        for (String key : this.defaultValues.keySet()) {
            String val = (String)this.defaultValues.get(key);
            log.debug("Adding default value '{}' = '{}'", (Object)key, (Object)val);
            msg.set(key, val);
        }
        String request = p.readToken(l);
        String status = p.readToken(l);
        String size = p.readToken(l);
        String referer = p.readToken(l);
        String userAgent = p.readToken(l);
        if (!MParser.isEmpty(userAgent)) {
            msg.set("REQUEST_HEADERS:User-Agent", userAgent);
        }
        if (!MParser.isEmpty(status)) {
            msg.set("RESPONSE_STATUS", status);
        }
        if (!MParser.isEmpty(size)) {
            msg.set("RESPONSE_SIZE", size);
        }
        if (!MParser.isEmpty(referer)) {
            msg.set("RESPONSE_HEADERS:Referer", referer);
        }
        if (!MParser.isEmpty(remoteUser)) {
            msg.set("REMOTE_USER", remoteUser);
        }
        msg.set("REMOTE_ADDR", remoteAddress);
        try {
            if (request.indexOf(" ") > 0) {
                String[] tok = request.split("\\s+");
                if (tok.length > 1) {
                    msg.set("REQUEST_URI", tok[1]);
                }
            } else {
                msg.set("REQUEST_URI", request);
            }
        }
        catch (Exception e) {
            log.error("Failed to extract REQUEST_URI from: {}", (Object)request);
            e.printStackTrace();
        }
        return msg;
    }

    public static void main(String[] args) throws Exception {
        String str = "[22/Nov/2009:12:41:43 +0100]";
        SimpleDateFormat fmt = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]");
        System.out.println("Format: [dd/MMM/yyyy:HH:mm:ss Z]");
        System.out.println("String: " + str);
        Date date = fmt.parse(str);
        System.out.println("Date: " + date);
        str = "[09/Dez/2009:20:45:51 +0100]";
        System.out.println("Format: [dd/MMM/yyyy:HH:mm:ss Z]");
        System.out.println("String: " + str);
        date = fmt.parse(str);
        System.out.println("Date: " + date);
        str = "91.209.196.76 - - [22/Nov/2009:09:09:10 +0100] \"quit\" 500 24576 \"-\" \"-\"";
        AccessLogParser parser = new AccessLogParser();
        parser.parse(str);
    }

    public class Tokenizer {
        int pos = 0;
        String str;
        String token = null;

        public Tokenizer(String str) {
            this.str = str;
            this.readNext();
        }

        public boolean endOfLine() {
            return this.pos >= this.str.length();
        }

        public boolean hasMoreTokens() {
            return this.token != null;
        }

        public String nextToken() {
            String cur = this.token;
            this.token = this.readNext();
            return cur;
        }

        private String readNext() {
            this.skipWhitespace();
            if (this.endOfLine()) {
                return null;
            }
            if (this.str.charAt(this.pos) == '\"') {
                return this.readQuoted('\"');
            }
            StringBuffer b = new StringBuffer();
            while (!this.endOfLine() && this.str.charAt(this.pos) != ' ') {
                b.append(this.str.charAt(this.pos++));
            }
            return b.toString();
        }

        private void skipWhitespace() {
            while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
                ++this.pos;
            }
        }

        public String readQuoted(char qc) {
            StringBuffer b = new StringBuffer();
            char last = ' ';
            while (!this.endOfLine() && this.str.charAt(this.pos) != qc && last != '\\') {
                last = this.str.charAt(this.pos++);
                b.append(last);
            }
            return b.toString();
        }
    }
}

