/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.io.BufferedReader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jwall.audit.EventType;
import org.jwall.log.LogMessage;
import org.jwall.log.LogMessageImpl;
import org.jwall.log.io.Parser;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericLogParser
implements Parser<LogMessage>,
Serializable {
    private static final long serialVersionUID = -7311309136161789947L;
    public static final String TIME_PATTERN = "\\d\\d:\\d\\d:\\d\\d";
    public static final String DATE_FORMAT1 = "EEE MMM dd HH:mm:ss yyyy";
    public static final String DATE_PATTERN1 = "\\[(.*?)\\]";
    public static final String DATE_FORMAT2 = "[dd/MMM/yyyy:HH:mm:ss Z]";
    public static final String DATE_PATTERN2 = "\\[\\d\\d/\\w{1,3}\\d{4,4}\\s\\d\\d:\\d\\d:\\d\\d\\s(.*)?\\+?.*\\]";
    public static Logger log = LoggerFactory.getLogger(GenericLogParser.class);
    String dateFormat = "[dd/MMM/yyyy:HH:mm:ss Z]";
    String datePattern = "\\[\\d\\d/\\w{1,3}\\d{4,4}\\s\\d\\d:\\d\\d:\\d\\d\\s(.*)?\\+?.*\\]";
    DateFormat fmt = new SimpleDateFormat(this.dateFormat, Locale.ENGLISH);
    Pattern p = Pattern.compile(this.dateFormat);
    BufferedReader reader;
    Map<String, String> defaultValues = new HashMap<String, String>();
    Parser<Map<String, String>> extractor = null;

    public GenericLogParser() {
    }

    public GenericLogParser(Parser<Map<String, String>> extractor) {
        this.extractor = extractor;
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
        this.defaultValues = new HashMap<String, String>(defaults);
    }

    @Override
    public Map<String, String> getDefaults() {
        return this.defaultValues;
    }

    public void setDefault(String key, String val) {
        this.defaultValues.put(key, val);
    }

    public String getDefault(String key) {
        return this.defaultValues.get(key);
    }

    public void setDateFormat(String fmt) {
        this.dateFormat = fmt;
    }

    public void setDatePattern(String pattern) {
        this.p = Pattern.compile(pattern);
    }

    @Override
    public LogMessage parse(String line) throws ParseException {
        if (line == null) {
            return null;
        }
        Long time = this.extractTimestamp(line);
        LogMessageImpl msg = new LogMessageImpl(EventType.GENERIC, time, "", line);
        for (String key : this.defaultValues.keySet()) {
            if (msg.get(key) == null) continue;
            msg.set(key, this.defaultValues.get(key));
        }
        if (this.extractor != null) {
            Map<String, String> features = this.extractor.parse(line);
            for (String key : features.keySet()) {
                msg.set(key, features.get(key));
            }
        }
        return msg;
    }

    protected Long extractTimestamp(String line) {
        Matcher m = this.p.matcher(line);
        while (m.find()) {
            try {
                int st = m.start() + 1;
                int en = m.end() - 1;
                log.info("Found date at {},{}", (Object)st, (Object)en);
                String str = m.group();
                log.info("   date: {}", (Object)str);
                return this.fmt.parse(str).getTime();
            }
            catch (Exception exception) {
            }
        }
        return System.currentTimeMillis();
    }
}

