/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AccessLogAuditReader;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.AuditFormatException;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ModSecurityAuditReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuditFormat {
    public static final int UNKNOWN_FORMAT = -1;
    public static final int APACHE_ACCESS_LOG = 0;
    public static final int MOD_SECURITY_1_X_SERIAL_LOG = 1;
    public static final int MOD_SECURITY_2_X_SERIAL_LOG = 2;
    public static final int MOD_SECURITY_2_X_CONCURRENT_LOG = 3;
    public static final int IRONBEE_AUDIT_LOG = 4;
    private static Logger log = LoggerFactory.getLogger((String)"AuditFormat");
    public static final String[] FORMAT_NAMES = new String[]{"Access Log", "ModSecurity 1.x Serial Audit-Log", "ModSecurity 2.x Serial Audit-Log", "ModSecurity 2.x Concurrent Audit-Log", "IronBee Audit-Log"};

    public static int guessFormat(File inFile) throws IOException {
        return AuditFormat.guessFormat(new FileInputStream(inFile));
    }

    public static int guessFormat(InputStream in) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        try {
            if (AuditFormat.isConcurrent2xLog(r)) {
                r.close();
                return 3;
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse ModSecurity 2.x Concurrent-Log, probably file in different Format");
        }
        try {
            if (AuditFormat.isAccessLog(r)) {
                r.close();
                return 0;
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse Apache Access-Log, probably file in different format!");
        }
        try {
            if (AuditFormat.isSerial2xLog(r)) {
                r.close();
                return 2;
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse ModSecurity 2.x Serial-Log, probably file in different format!");
        }
        try {
            if (AuditFormat.isSerial1xLog(r)) {
                r.close();
                return 1;
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse ModSecurity 1.x Serial-Log, probably file in different format!");
        }
        r.close();
        return -1;
    }

    public static boolean isAccessLog(BufferedReader r) throws IOException {
        if (r.markSupported()) {
            r.mark(4096);
        }
        try {
            AuditEvent evt;
            String line = r.readLine();
            if (line != null && (evt = AccessLogAuditReader.createEvent(line)) != null) {
                if (r.markSupported()) {
                    r.reset();
                }
                return true;
            }
        }
        catch (Exception e) {
            if (r.markSupported()) {
                r.reset();
            }
            return false;
        }
        r.reset();
        return false;
    }

    public static boolean isConcurrent2xLog(BufferedReader r) throws IOException {
        r.mark(4096);
        int retry = 2;
        while (retry-- > 0) {
            String line = r.readLine();
            log.debug("Checking line: {}", (Object)line);
            if (line != null && line.split(" ").length < 3) {
                r.reset();
                return false;
            }
            String[] token = AccessLogAuditReader.splitAccessLine(line);
            if (token.length <= 14) continue;
            String id = token[10];
            String match = "^/\\d*/\\d*-\\d*/\\d*-\\d*-" + id + "$";
            if (!token[12].matches(match)) continue;
            r.reset();
            return true;
        }
        r.reset();
        return false;
    }

    public static boolean isSerial1xLog(BufferedReader r) throws IOException {
        if (r.markSupported()) {
            r.mark(4096);
        }
        int retry = 25;
        while (retry-- > 0) {
            String line = r.readLine();
            if (line == null) {
                return false;
            }
            if (!line.matches("^========================================$")) continue;
            if (r.markSupported()) {
                r.reset();
            }
            return true;
        }
        try {
            if (r.markSupported()) {
                r.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isSerial2xLog(BufferedReader r) throws IOException {
        if (r.markSupported()) {
            r.mark(4096);
        }
        int retry = 10;
        while (retry-- > 0) {
            String line = r.readLine();
            if (line == null) {
                return false;
            }
            if (!line.matches("^--[A-Za-z0-9]*-A--$")) continue;
            if (r.markSupported()) {
                r.reset();
            }
            return true;
        }
        if (r.markSupported()) {
            r.reset();
        }
        return false;
    }

    public static AuditEventReader createReader(String filename, boolean tail) throws IOException, AuditFormatException {
        AbstractAuditEventReader reader = null;
        File logFile = new File(filename);
        int fmt = AuditFormat.guessFormat(logFile);
        if (fmt == 0) {
            reader = new AccessLogAuditReader(logFile, tail);
        }
        if (fmt == 1) {
            reader = new ModSecurityAuditReader(logFile, tail);
        }
        if (fmt == 2) {
            reader = new ModSecurity2AuditReader(logFile, tail);
        }
        if (reader == null) {
            throw new AuditFormatException("The log-file format is not supported!");
        }
        return reader;
    }
}

