/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;

public abstract class IronBeeSectionParser
implements Processor {
    static Logger log = LoggerFactory.getLogger(IronBeeSectionParser.class);
    final Map<String, String> sectionHeader = new LinkedHashMap<String, String>();

    public abstract String getSectionName();

    public Data process(Data input) {
        Serializable section = (Serializable)input.get((Object)this.getSectionName());
        if (section == null) {
            return input;
        }
        try {
            this.sectionHeader.clear();
            BufferedReader reader = new BufferedReader(new StringReader(section.toString()));
            String line = reader.readLine();
            while (line != null && !"".equals(line.trim())) {
                log.trace("Parsing section-header: {}", (Object)line);
                String[] tok = line.split(": ", 2);
                if (tok.length == 2) {
                    log.trace("Adding    ( {}, {} )", (Object)tok[0], (Object)tok[1]);
                    this.sectionHeader.put(tok[0], tok[1]);
                } else {
                    log.warn("Invalid section-header: {}", (Object)line);
                }
                line = reader.readLine();
            }
            input = this.parseSection(reader, input);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return input;
    }

    public abstract Data parseSection(BufferedReader var1, Data var2) throws IOException;
}

