/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAddressResolver
implements EventProcessor<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(RemoteAddressResolver.class);
    String from = "REQUEST_HEADERS:X-Orig-Source-IP".toUpperCase();

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        String txId = event.get("TX_ID");
        log.debug("Trying to resolve true remote-address for {}", (Object)txId);
        String addr = event.get(this.from);
        log.debug("Extracted address value is: '{}'", (Object)addr);
        if (addr != null && !"".equals(addr.trim())) {
            addr = addr.trim();
            String remote = event.get("REMOTE_ADDR");
            log.info("Replacing REMOTE_ADDR '{}' with '{}'", (Object)remote, (Object)addr);
            event.set("REMOTE_ADDR", addr);
        } else {
            log.debug("No original address could be extracted from '{}' for event {}", (Object)this.from, (Object)txId);
        }
        return event;
    }
}

