/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.util.List;
import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Description;

@Description(group="AuditEvent.Processing", text="This processor adds all rule-tags as tags for the event.")
public class RuleTagProcessor
implements EventProcessor<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(RuleTagProcessor.class);
    String separator = "|";
    String user = "system";

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        log.debug("adding RuleTags to event {}", (Object)event.get("TX_ID"));
        StringBuilder s = new StringBuilder();
        String existingTags = event.get("TAGS");
        if (existingTags != null) {
            s.append(existingTags);
        }
        int added = 0;
        Object[] msgs = event.getEventMessages();
        log.debug("EventMessages: {}", msgs);
        if (msgs == null) {
            return event;
        }
        for (Object msg : msgs) {
            log.debug("Processing message: {}", msg);
            List<String> tags = msg.getRuleTags();
            if (tags == null) continue;
            for (String tag : tags) {
                if (s.length() > 0) {
                    s.append(this.separator);
                }
                s.append(this.user);
                s.append(":");
                s.append(tag);
                ++added;
            }
        }
        if (added > 0) {
            String tagString = s.toString();
            log.debug("Adding final tag-string: '{}'", (Object)tagString);
            event.set("TAGS", tagString);
        }
        return event;
    }
}

