/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.session;

import java.util.HashMap;
import java.util.LinkedList;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.session.AbstractSessionTracker;

public class HeuristicSessionTracker
extends AbstractSessionTracker {
    public HeuristicSessionTracker(long sessionTime) {
        super(sessionTime);
        this.sessionTimeOut = sessionTime;
        this.activeSessions = new HashMap();
        this.timedOutSessions = new LinkedList();
    }

    @Override
    public String extractKey(AuditEvent evt) {
        try {
            StringBuffer msg = new StringBuffer();
            String addr = evt.get("REMOTE_ADDR");
            msg.append(addr);
            String ua = evt.get("REQUEST_HEADERS:User-Agent");
            if (ua != null) {
                msg.append(ua);
            }
            return msg.toString();
        }
        catch (Exception e) {
            return evt.get("REMOTE_ADDR");
        }
    }

    @Override
    public String toString() {
        return "HeuristicSessionTracker[" + this.sessionTimeOut + "]";
    }
}

