/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jwall.web.audit.util.Obfuscator;

public class ClientIPObfuscation
implements Obfuscator {
    public static final String IPv4_ADDRESS_PATTERN = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
    public static final String IPv6_ADDRESS_PATTERN = "[a-f0-9]{0,4}:[a-f0-9]{1,4}";
    static String IPv4_REPLACEMENT = System.getProperty("ipv4.replacement");
    static String IPv6_REPLACEMENT = System.getProperty("ipv6.replacement");
    static Pattern ipv6address = Pattern.compile("[a-f0-9]{0,4}:[a-f0-9]{1,4}");
    static Pattern ipv4address = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    List<Integer> sections = new LinkedList<Integer>();
    String lastClientIP = null;
    String lastClientPort = null;
    String lastServerIP = null;
    String lastServerPort = null;
    Map<String, String> replacements = new HashMap<String, String>();

    public ClientIPObfuscation() {
        this.sections.add(0);
        this.sections.add(1);
        this.sections.add(7);
        this.sections.add(10);
        if (IPv4_REPLACEMENT == null) {
            IPv4_REPLACEMENT = "x.x.x.x";
        }
        if (IPv6_REPLACEMENT == null) {
            IPv6_REPLACEMENT = "ffff::f";
        }
    }

    @Override
    public List<Integer> getSections() {
        return this.sections;
    }

    @Override
    public String obfuscate(Integer id, String sectionData) throws IOException {
        if (!this.sections.contains(id)) {
            return sectionData;
        }
        if (id == 0) {
            String[] s = sectionData.trim().split(" ");
            this.lastClientIP = s[3];
            if (this.lastClientIP.indexOf(":") >= 0) {
                this.replacements.put(this.lastClientIP, IPv6_REPLACEMENT);
            } else {
                this.replacements.put(this.lastClientIP, IPv4_REPLACEMENT);
            }
            this.lastClientPort = s[4];
            this.lastServerIP = s[5];
            this.lastServerPort = s[6];
            String obfuscated = sectionData.replace(this.lastClientIP, this.getReplacement());
            return obfuscated;
        }
        if (id == 1 || id == 10 || id == 7) {
            StringBuffer obfuscated = new StringBuffer();
            BufferedReader r = new BufferedReader(new StringReader(sectionData));
            String line = r.readLine();
            while (line != null) {
                if (line.toLowerCase().startsWith("x-forwarded-for:")) {
                    line = line.replaceAll(IPv4_ADDRESS_PATTERN, IPv4_REPLACEMENT);
                }
                if (this.lastClientIP != null && line.indexOf(this.lastClientIP) >= 0) {
                    line = line.replace(this.lastClientIP, this.replacements.get(this.lastClientIP));
                }
                obfuscated.append(line);
                obfuscated.append("\r\n");
                line = r.readLine();
            }
            return obfuscated.toString();
        }
        return sectionData;
    }

    public String getExpression() {
        return IPv4_ADDRESS_PATTERN;
    }

    public String getReplacement() {
        return "x.x.x.x";
    }

    public String getVariable() {
        return "REMOTE_ADDR";
    }

    @Override
    public void done() {
        this.lastClientIP = null;
    }
}

