/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jwall.log.LogMessage;
import org.jwall.log.io.GenericLogParser;
import org.jwall.log.io.LogReader;

public class GenericLogReader
implements LogReader {
    public static final String TIME_PATTERN = "\\d\\d:\\d\\d:\\d\\d";
    public static final String DATE_FORMAT1 = "EEE MMM dd HH:mm:ss yyyy";
    public static final String DATE_PATTERN1 = "\\[(.*?)\\]";
    public static final String DATE_FORMAT2 = "[dd/MMM/yyyy HH:mm:ss Z]";
    public static final String DATE_PATTERN2 = "\\[\\d\\d/\\w{1,3}\\d{4,4}\\s\\d\\d:\\d\\d:\\d\\d\\s(.*)?\\]";
    String dateFormat = "EEE MMM dd HH:mm:ss yyyy";
    String datePattern = "\\[(.*?)\\]";
    DateFormat fmt = new SimpleDateFormat(this.dateFormat, Locale.ENGLISH);
    Pattern p;
    BufferedReader reader;
    GenericLogParser parser;

    public GenericLogReader(GenericLogParser parse, Reader r) {
        this.parser = parse;
        this.reader = new BufferedReader(r);
        this.p = Pattern.compile(this.datePattern);
    }

    public GenericLogReader(GenericLogParser parse, InputStream in) {
        this(parse, new InputStreamReader(in));
    }

    public GenericLogReader(GenericLogParser parse, InputStream in, String dPattern, String dFormat) {
        this(parse, in);
        this.datePattern = dPattern;
        this.dateFormat = dFormat;
        this.fmt = new SimpleDateFormat(this.dateFormat, Locale.ENGLISH);
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
        this.parser.setDefaults(defaults);
    }

    public void setDefault(String key, String val) {
        this.parser.setDefault(key, val);
    }

    public String getDefault(String key) {
        return this.parser.getDefault(key);
    }

    @Override
    public LogMessage readNext() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        try {
            LogMessage msg = this.parser.parse(line);
            return msg;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected Long extractTimestamp(String line) {
        Matcher m = this.p.matcher(line);
        while (m.find()) {
            try {
                String str = line.substring(m.start() + 1, m.end() - 1);
                return this.fmt.parse(str).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        return System.currentTimeMillis();
    }
}

