/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jwall.audit.EventType;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.ModSecurity;
import org.jwall.web.audit.io.AuditEventParser;
import org.jwall.web.audit.io.MessageParser;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSecurityAuditEvent
implements Comparable<AuditEvent>,
Serializable,
AuditEvent {
    private static final long serialVersionUID = 7828115034635641145L;
    private static Logger log = LoggerFactory.getLogger(ModSecurityAuditEvent.class);
    protected static Long evtCount = 0L;
    public static final SimpleDateFormat fmt = new SimpleDateFormat("d/MMM/y:HH:mm:ss Z", Locale.ENGLISH);
    private Date createdAt;
    protected String eventId;
    private String[] sections;
    Map<String, List<String>> collections;
    String sessionId;
    private URL url;
    private File file;
    private long offset;
    private long size;
    final AuditEventType type;
    AuditEventMessage[] messages;

    protected ModSecurityAuditEvent(AuditEventType type) {
        this.eventId = "";
        this.collections = null;
        this.url = null;
        this.file = null;
        this.offset = -1L;
        this.size = -1L;
        this.messages = null;
        this.type = type;
        this.collections = new LinkedHashMap<String, List<String>>();
    }

    public ModSecurityAuditEvent(ModSecurityAuditEvent evt) throws Exception {
        this(evt.sections, evt.type);
    }

    public String[] getSections() {
        return this.sections;
    }

    @Override
    public EventType getType() {
        return EventType.AUDIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModSecurityAuditEvent(String[] data, AuditEventType type) throws ParseException {
        block13: {
            this(type);
            this.sections = (String[])data.clone();
            if (data.length < 1 || data[0] == null || "".equals(data[0])) {
                throw new ParseException("No audit-header found !");
            }
            try {
                log.debug("Parsing request-header...");
                AuditEventParser.parseHttpHeader(this.collections, this.sections[1]);
                log.debug("Parsing response header...");
                AuditEventParser.parseHttpHeader(this.collections, this.sections[5]);
            }
            catch (ParseException e) {
                if (data != null && data.length > 0) {
                    log.debug("AuditHeader of event to be parsed: '" + data[0] + "'");
                } else {
                    log.debug("ScriptEvent doesn't even contain an audit-header!");
                }
                if (!log.isDebugEnabled()) break block13;
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == null || "".equals(data[i])) continue;
                    String d = data[i];
                    b.append("--SECTION-" + "ABCDEFGHIJKTXZ".charAt(i) + "--\r\n");
                    b.append(d);
                }
                b.append("--SECTION-Z--\r\n");
                b.append("\r\n-------------------------------\r\n");
                log.debug(b.toString());
            }
        }
        this.parseSections(this.sections);
        if (this.collections.get("QUERY_STRING") != null) {
            log.debug("Parsing parameters from query string: " + this.collections.get("QUERY_STRING").get(0));
            AuditEventParser.parseParameters(this.collections, "QUERY_STRING", this.collections.get("QUERY_STRING").get(0));
        }
        if (data.length >= 8 && data[8] != null) {
            log.debug("Parsing parameters from section-form-data...");
            AuditEventParser.parseParameters(this.collections, "REQUEST_BODY", data[2]);
        }
        if (data.length >= 7 && data[7] != null) {
            AuditEventParser.parseAuditTrailer(this.collections, this.sections[7]);
        }
        this.size = 0L;
        for (String sec : this.sections) {
            this.size += (long)sec.length();
        }
        this.sessionId = "";
        Long l = evtCount;
        synchronized (l) {
            Long l2 = evtCount;
            Long l3 = evtCount = Long.valueOf(evtCount + 1L);
        }
    }

    public ModSecurityAuditEvent(String id, String[] data, File f, long off, long size, AuditEventType type) throws ParseException {
        this(data, type);
        this.eventId = id;
        this.file = f;
        this.offset = off;
        this.size = size;
        AuditEventParser.setValue(this.collections, "EVENT_ID", id);
    }

    public ModSecurityAuditEvent(String id, String[] data, AuditEventType type) throws Exception {
        this(data, type);
        this.eventId = id;
    }

    @Override
    public Long getTimestamp() {
        if (this.createdAt == null) {
            this.createdAt = new Date(System.currentTimeMillis());
        }
        return this.createdAt.getTime();
    }

    protected void parseSections(String[] sections) throws ParseException {
        this.createdAt = AuditEventParser.parseDate(sections[0]);
        String[] s = sections[0].trim().split(" ");
        if (s.length < 7) {
            throw new ParseException("Error while parsing AuditLog-Header: " + sections[0]);
        }
        this.eventId = Long.toHexString(this.createdAt.getTime());
        AuditEventParser.addValue(this.collections, "TX_ID", s[2]);
        AuditEventParser.addValue(this.collections, "REMOTE_ADDR", s[3]);
        AuditEventParser.addValue(this.collections, "REMOTE_HOST", s[3]);
        AuditEventParser.addValue(this.collections, "REMOTE_PORT", s[4]);
        AuditEventParser.addValue(this.collections, "SERVER_ADDR", s[5]);
        AuditEventParser.addValue(this.collections, "SERVER_NAME", s[5]);
        if (s[6].equals("www")) {
            s[6] = "80";
        }
        AuditEventParser.addValue(this.collections, "SERVER_PORT", s[6]);
        AuditEventParser.addValue(this.collections, "REMOTE_USER", "-");
        if (sections.length >= 7 && sections[7] != null) {
            AuditEventParser.addValue(this.collections, "__AUDIT_LOG_TRAILER__", sections[7]);
        }
        AuditEventParser.setValue(this.collections, "REQUEST_HEADER", sections[1]);
        if (sections[2] != null) {
            AuditEventParser.setValue(this.collections, "REQUEST_BODY", sections[2]);
        }
        if (sections[5] != null) {
            AuditEventParser.setValue(this.collections, "RESPONSE_HEADER", sections[5]);
        }
        if (ModSecurity.SECTION_META_INF > 0 && sections[ModSecurity.SECTION_META_INF] != null) {
            AuditEventParser.parseMetaInfSection(this.collections, sections[ModSecurity.SECTION_META_INF]);
        }
    }

    @Override
    public String getEventId() {
        String id = this.get("TX_ID");
        if (id != null) {
            return id;
        }
        return this.eventId;
    }

    @Override
    public String getSection(int i) {
        if (i >= 0 && i < this.sections.length) {
            return this.sections[i];
        }
        return null;
    }

    public String getAuditHeader() {
        return this.sections[0];
    }

    public String getRequestHeader() {
        return this.sections[1];
    }

    public String getRequestBody() {
        return this.sections[2];
    }

    public String getResponseHeader() {
        return this.sections[5];
    }

    public String getAuditLogTrailer() {
        return this.sections[7];
    }

    @Override
    public Date getDate() {
        return new Date(this.createdAt.getTime());
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String id) {
        this.sessionId = id;
        AuditEventParser.setValue(this.collections, "SESSIONID", id);
    }

    @Override
    public boolean isSet(String var) {
        if (var == null) {
            return false;
        }
        String v = var;
        if (!ModSecurity.isCaseSensitive(v)) {
            v = var.toUpperCase();
        }
        return this.collections.get(v) != null;
    }

    @Override
    public String get(String variable) {
        String var = variable;
        if (var == null) {
            return "";
        }
        if ("UNIQUE_ID".equals(variable)) {
            return this.get("TX_ID");
        }
        if (!ModSecurity.isCaseSensitive(variable)) {
            var = variable.toUpperCase();
        }
        if ("__UNDEFINED__".equals(var)) {
            return "";
        }
        if (var.startsWith("&")) {
            String col = var.substring(1);
            return "" + this.getAll(col).size();
        }
        if (this.collections.containsKey(var)) {
            if (this.collections.get(var).isEmpty()) {
                return "";
            }
            return this.collections.get(var).get(0);
        }
        return "";
    }

    @Override
    public List<String> getAll(String v) {
        String var = v;
        if (!ModSecurity.isCaseSensitive(v)) {
            var = v.toUpperCase();
        }
        if (this.collections.containsKey(var)) {
            return this.collections.get(var);
        }
        LinkedList<String> vals = new LinkedList<String>();
        String val = this.get(var);
        if (!"".equals(val)) {
            vals.add(val);
        }
        return vals;
    }

    @Override
    public List<String> getVariables() {
        LinkedList<String> names = new LinkedList<String>();
        names.addAll(this.collections.keySet());
        return names;
    }

    @Override
    public void set(String var, String val) {
        AuditEventParser.setValue(this.collections, var, val);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].length() <= 0) continue;
            s.append("--" + this.getEventId() + "-" + "ABCDEFGHIJKTXZ".charAt(i) + "--\n");
            s.append(this.sections[i]);
        }
        s.append("--" + this.getEventId() + "-Z--\n");
        return s.toString();
    }

    @Override
    public int compareTo(AuditEvent o) {
        if (o instanceof ModSecurityAuditEvent) {
            return this.compareTo((ModSecurityAuditEvent)o);
        }
        return -1;
    }

    @Override
    public int compareTo(ModSecurityAuditEvent o) {
        if (this.eventId.compareTo(o.eventId) == 0) {
            return 0;
        }
        int c = this.getDate().compareTo(o.getDate());
        if (c == 0) {
            return this.eventId.compareTo(o.eventId);
        }
        return c;
    }

    public boolean equals(ModSecurityAuditEvent o) {
        return 0 == this.compareTo(o);
    }

    @Override
    public String[] getRawData() {
        return this.sections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Long l = evtCount;
        synchronized (l) {
            Long l2 = evtCount;
            Long l3 = evtCount = Long.valueOf(evtCount - 1L);
        }
    }

    public Long getCount() {
        return evtCount;
    }

    public URL getRequestURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public void recycle() {
    }

    public void tag(String tag) {
        List<String> tags = this.collections.get("TAGS");
        if (tags == null) {
            tags = new LinkedList<String>();
            this.collections.put("TAGS", tags);
        }
        if (!tags.contains(tag)) {
            tags.add(tag);
        }
    }

    public void untag(String tag) {
        List<String> tags = this.collections.get("TAGS");
        if (tags != null) {
            tags.remove(tag);
        }
    }

    public Set<String> getTags() {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        List<String> taglist = this.collections.get("TAGS");
        if (taglist != null) {
            tags.addAll(taglist);
        }
        return tags;
    }

    public static Long getInstanceCount() {
        return evtCount;
    }

    @Override
    public void setAll(String variable, List<String> values) {
        if (this.collections == null) {
            this.collections = new LinkedHashMap<String, List<String>>();
        }
        if (ModSecurity.isCaseSensitive(variable)) {
            this.collections.put(variable, values);
        } else {
            this.collections.put(variable.toUpperCase(), values);
        }
    }

    @Override
    public AuditEventType getAuditEventType() {
        return this.type;
    }

    @Override
    public AuditEventMessage[] getEventMessages() {
        if (this.messages != null) {
            return this.messages;
        }
        List<AuditEventMessage> msgs = MessageParser.parseMessages(this);
        this.messages = msgs.toArray(new AuditEventMessage[msgs.size()]);
        return this.messages;
    }
}

