/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jwall.Collector;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.ConcurrentAuditWriter;
import org.jwall.web.audit.util.Base64Codec;
import org.jwall.web.audit.util.MD5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventConsoleSender
implements AuditEventListener {
    public static final String CONSOLE_HOST = "org.modsecurity.console.host";
    public static final String CONSOLE_PORT = "org.modsecurity.console.port";
    public static final String CONSOLE_USER = "org.modsecurity.console.user";
    public static final String CONSOLE_PASS = "org.modsecurity.console.password";
    public static final String CONSOLE_CONNECTION_KEEP_ALIVE = "org.modsecurity.collector.keep-alive";
    public static final String CONSOLE_CONNECTION_SSL = "org.modsecurity.collector.ssl-enabled";
    private static Logger log = LoggerFactory.getLogger((String)"AuditEventConsoleSender");
    public static final String CONSOLE_URI = "/rpc/auditLogReceiver";
    private String host = "localhost";
    private int port = 8888;
    private String user = "";
    private String pass = "";
    private Socket socket = null;

    public AuditEventConsoleSender(String host, int port, String login, String password) {
        this.host = host;
        this.port = port;
        this.user = login;
        this.pass = password;
        try {
            log.debug("Disabling certificate validation...");
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new ZeroTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAuditEvent(AuditEvent evt) throws Exception {
        byte[] data = evt.toString().getBytes();
        String hash = "md5:" + MD5.md5(data);
        String sum = ConcurrentAuditWriter.createSummary(evt);
        Base64Codec codec = new Base64Codec();
        String cred = new String(codec.encode((this.user + ":" + this.pass).getBytes()));
        String ua = "jwall.org/Collector Version 0.2.17";
        Socket sock = this.getSocketConnection();
        try {
            StringBuffer request = new StringBuffer();
            request.append("PUT " + Collector.p.getProperty(CONSOLE_URI) + " HTTP/1.1\r\n");
            request.append("Authorization: Basic " + cred + "\r\n");
            request.append("Host: " + this.host);
            if (this.port != 80) {
                request.append(":" + this.port);
            }
            request.append("\r\n");
            request.append("X-Content-Hash: " + hash + "\r\n");
            request.append("X-ForensicLog-Summary: " + sum + "\r\n");
            request.append("User-Agent: " + ua + "\r\n");
            if ("true".equalsIgnoreCase(Collector.getProperty(CONSOLE_CONNECTION_KEEP_ALIVE))) {
                request.append("Connection: keep-alive\r\n");
            }
            request.append("Content-Length: " + data.length + "\r\n");
            request.append("\r\n");
            PrintStream out = new PrintStream(sock.getOutputStream());
            out.print(request.toString());
            log.debug("Writing " + data.length + " bytes of data to server...");
            out.write(data);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            sock = null;
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        String line = r.readLine();
        if (line != null) {
            if (line.toLowerCase().indexOf("200 ok") >= 0) {
                log.debug("Server accepted event.");
            } else {
                log.debug("Response-line: " + line);
            }
        }
        while (line != null && !"".equals(line.trim())) {
            log.debug("RESPONSE: " + line);
            line = r.readLine();
        }
        r.close();
        if ("true".equalsIgnoreCase(Collector.getProperty(CONSOLE_CONNECTION_KEEP_ALIVE))) {
            return;
        }
        this.closeSocketConnection();
    }

    public Socket getSocketConnection() throws Exception {
        if (this.socket != null && !this.socket.isClosed()) {
            return this.socket;
        }
        log.debug("Establishing socket connection");
        String ssl = Collector.getProperty(CONSOLE_CONNECTION_SSL);
        if (ssl != null && !"false".equalsIgnoreCase(ssl)) {
            log.debug("Creating new ssl-enabled socket to " + this.host + ":" + this.port);
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = new TrustManager[]{new ZeroTrustManager()};
            context.init(null, trustManagers, null);
            SSLSocketFactory sf = context.getSocketFactory();
            this.socket = sf.createSocket(this.host, this.port);
        } else {
            log.debug("Creating new plain-http socket to " + this.host + ":" + this.port);
            this.socket = new Socket(this.host, this.port);
        }
        return this.socket;
    }

    public void closeSocketConnection() throws Exception {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.socket = null;
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        try {
            this.sendAuditEvent(evt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    public class ZeroTrustManager
    implements X509TrustManager,
    TrustManager {
        private Logger log = LoggerFactory.getLogger((String)"ZeroTrustManager");

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.log.debug("checkClientTrusted: \n");
            for (X509Certificate cert : chain) {
                this.log.debug("-------------------------------------------------------");
                this.log.debug(" SubjectDN = " + cert.getSubjectDN());
                this.log.debug(" Issuer = " + cert.getIssuerDN());
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.log.debug("checkServerTrusted: \n");
            for (X509Certificate cert : chain) {
                this.log.debug("-------------------------------------------------------");
                this.log.debug(" SubjectDN = " + cert.getSubjectDN());
                this.log.debug(" Issuer = " + cert.getIssuerDN());
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

