/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.session.Session;
import org.jwall.web.audit.session.SessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionTracker
implements SessionTracker {
    static Logger log = LoggerFactory.getLogger(AbstractSessionTracker.class);
    protected long sessionTimeOut = 0x6DDD00L;
    protected HashMap<String, Session> activeSessions = new HashMap();
    protected List<Session> timedOutSessions = new LinkedList<Session>();
    protected int type = -1;
    boolean strictSessions = true;

    public AbstractSessionTracker() {
    }

    public AbstractSessionTracker(long timeout) {
        this();
        this.setSessionTimeOut(timeout);
    }

    @Override
    public void eventArrived(AuditEvent event) {
        String key = this.extractKey(event);
        if (key == null) {
            log.debug("Ignoring event without session-key {}", (Object)event.getEventId());
            return;
        }
        log.trace("Found session-id '{}'!", (Object)key);
        Session s = this.activeSessions.get(key);
        if (s == null) {
            log.debug("creating a new session ({}): {}", (Object)this.activeSessions.keySet().size(), (Object)key);
            Session sess = new Session(this.type, key, event);
            this.activeSessions.put(key, sess);
            event.setSessionId(sess.getId());
            event.set("SESSIONID", s.getId());
        } else if (this.isExpired(s, event)) {
            this.expireSession(s);
            s = this.createSession(event);
            if (s == null) {
                return;
            }
            event.setSessionId(s.getId());
            event.set("SESSIONID", s.getId());
        } else {
            s.addEvent(event);
            event.setSessionId(s.getId());
            event.set("SESSIONID", s.getId());
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    protected void expireSession(Session s) {
        this.activeSessions.remove(s.getId());
        this.timedOutSessions.add(s);
    }

    @Override
    public Session getSession(String sessionId) {
        return this.activeSessions.get(sessionId);
    }

    private Session createSession(AuditEvent event) {
        String key = this.extractKey(event);
        if (key == null) {
            return null;
        }
        Session s = this.activeSessions.get(key);
        if (s != null && this.isExpired(s, event)) {
            this.activeSessions.remove(key);
            this.timedOutSessions.add(s);
            s = null;
        }
        if (s == null) {
            s = new Session(this.type, key, event);
            event.setSessionId(s.getId());
            this.activeSessions.put(key, s);
        }
        return s;
    }

    @Override
    public Collection<Session> getSessions() {
        Vector<Session> v = new Vector<Session>();
        v.addAll(this.timedOutSessions);
        v.addAll(this.activeSessions.values());
        return v;
    }

    @Override
    public void reset() {
        this.activeSessions.clear();
        this.timedOutSessions.clear();
    }

    public boolean isExpired(Session s, AuditEvent event) {
        return event.getDate().getTime() - s.lastAccessed().getTime() > this.sessionTimeOut;
    }

    @Override
    public void setSessionTimeOut(long s) {
        this.sessionTimeOut = s;
    }

    @Override
    public long getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    @Override
    public void setStrictSessions(boolean b) {
        this.strictSessions = b;
    }

    @Override
    public boolean usesStrictSessions() {
        return this.strictSessions;
    }

    public abstract String extractKey(AuditEvent var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Session s : this.getSessions()) {
            sb.append("-------SESSION: " + s.getId() + "---------------------------\n");
        }
        return sb.toString();
    }
}

