/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEventProcessorPipeline;
import org.jwall.web.audit.util.VariableContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.setup.ObjectFactory;

public class AuditEventProcessorFinder {
    static Logger log = LoggerFactory.getLogger(AuditEventProcessorFinder.class);
    static final ObjectFactory objectFactory = ObjectFactory.newInstance();

    static {
        objectFactory.addPackage("org.jwall.audit.processor");
        objectFactory.addPackage("org.jwall.web.audit.processor");
    }

    public static AuditEventProcessorPipeline deployCustomEventProcessors(File file) throws Exception {
        AuditEventProcessorPipeline pipe = new AuditEventProcessorPipeline();
        AuditEventProcessorFinder finder = new AuditEventProcessorFinder();
        finder.deployCustomEventProcessors(file, pipe);
        return pipe;
    }

    public AuditEventProcessorFinder() {
        for (Object k : System.getProperties().keySet()) {
            String key = k.toString();
            String value = System.getProperty(key);
            log.debug("Adding ('{}', '{}') to object-factory...", (Object)key, (Object)value);
            objectFactory.set(key, value);
        }
    }

    public void deployCustomEventProcessors(File procDefs, AuditEventProcessorPipeline pipeline) throws Exception {
        this.deployCustomEventProcessors(new FileInputStream(procDefs), pipeline);
    }

    public void deployCustomEventProcessors(InputStream processorDefinitions, AuditEventProcessorPipeline pipeline) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(processorDefinitions);
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("event-processors")) {
            AuditEventProcessorFinder.registerProcessors(pipeline, root.getChildNodes());
            return;
        }
        NodeList eventProcessorList = root.getElementsByTagName("event-processors");
        AuditEventProcessorFinder.registerProcessors(pipeline, eventProcessorList);
    }

    protected static void registerProcessors(AuditEventProcessorPipeline pipeline, NodeList eventProcessorList) {
        int j = 0;
        while (j < eventProcessorList.getLength()) {
            Node epNode = eventProcessorList.item(j);
            if (epNode.getNodeType() == 1) {
                AuditEventProcessorFinder.registerProcessors(pipeline, (Element)epNode);
            }
            ++j;
        }
    }

    protected static void registerProcessors(AuditEventProcessorPipeline pipeline, Element node) {
        block5: {
            try {
                Map params = objectFactory.getAttributes((Node)node);
                Double priority = new Double(1000.0);
                if (params.get("priority") != null) {
                    priority = new Double((String)params.get("priority"));
                }
                log.info("Found priority {}", (Object)priority);
                Map parameter = objectFactory.getAttributes((Node)node);
                HashMap<String, String> expanded = new HashMap<String, String>();
                VariableContext ctx = new VariableContext(System.getProperties());
                for (String key : parameter.keySet()) {
                    expanded.put(key, ctx.expand((String)parameter.get(key)));
                }
                log.debug("Creating object from '{}' with parameters: {}", (Object)node.getNodeName(), expanded);
                Object o = objectFactory.create(node.getNodeName(), expanded, node);
                if (o instanceof EventProcessor) {
                    EventProcessor eventProcessor = (EventProcessor)o;
                    log.debug("Registering AuditEventProcessor {} with priority {}", (Object)eventProcessor, (Object)priority);
                    pipeline.register(priority, eventProcessor);
                }
            }
            catch (Exception e) {
                log.error("Failed to register processor: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
    }
}

