/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jwall.log.io.MParser;
import org.jwall.log.io.Parser;
import org.jwall.web.audit.io.ParseException;

public class TimeParser
extends MParser
implements Parser<Long> {
    public static final Long SECOND = 1000L;
    public static final Long MINUTE = 60L * SECOND;
    public static final Long HOUR = 60L * MINUTE;
    public static final Long DAY = 24L * HOUR;
    public static final Long WEEK = 7L * DAY;
    public static final Long MONTH = 30L * DAY;
    public static final Long YEAR = 12L * MONTH;
    public static final Map<String, Long> units = new LinkedHashMap<String, Long>();

    static {
        units.put("sec", SECOND);
        units.put("min", MINUTE);
        units.put("hour", HOUR);
        units.put("day", DAY);
        units.put("week", WEEK);
        units.put("month", MONTH);
        units.put("year", YEAR);
    }

    @Override
    public Map<String, String> getDefaults() {
        return null;
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
    }

    public Long readTimeUnit(String str) throws ParseException {
        int start = this.pos;
        this.skipBlanks(str);
        String token = this.readNonNumeric(str);
        Long unit = this.guessUnit(token);
        if (unit > 0L) {
            return unit;
        }
        throw new ParseException("No valid time-unit found at '" + str.substring(start) + "'!");
    }

    public String readNonNumeric(String str) {
        this.skipBlanks(str);
        StringBuffer s = new StringBuffer();
        while (this.pos < str.length() && !Character.isWhitespace(str.charAt(this.pos)) && !Character.isDigit(str.charAt(this.pos))) {
            s.append(str.charAt(this.pos));
            ++this.pos;
        }
        return s.toString();
    }

    public Long guessUnit(String name) {
        for (String key : units.keySet()) {
            if (!key.startsWith(name) && !name.startsWith(key)) continue;
            return units.get(key);
        }
        return 0L;
    }

    @Override
    public Long parse(String str) throws ParseException {
        Long value = 0L;
        this.skipBlanks(str);
        while (!"".equals(str.substring(this.pos).trim()) && !TimeParser.isBlank(this.remainder(str))) {
            Integer i = this.readInteger(str);
            this.skipBlanks(str);
            Long unit = this.readTimeUnit(str);
            value = value + (long)i.intValue() * unit;
        }
        return value;
    }
}

