/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventFactory;
import org.jwall.web.audit.DefaultAuditEventFactory;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditEventReader
implements AuditEventReader {
    public static final String DEFAULT_AUDIT_EVENT_FACTORY_CLASS = DefaultAuditEventFactory.class.getName();
    private static Logger log = LoggerFactory.getLogger(AbstractAuditEventReader.class);
    protected BufferedReader reader;
    protected AuditEventFactory eventFactory = null;
    protected File inputFile = null;
    protected int counter = 0;
    protected double fileSize = 0.0;
    protected double bytesRead = 0.0;
    protected AuditEvent pending = null;
    protected boolean eofReached = false;

    public AbstractAuditEventReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public AbstractAuditEventReader(Reader in) {
        try {
            Class<?> factory;
            AuditEventFactory factoryClass;
            String factoryClassName = System.getProperty("org.jwall.web.audit.AuditEventFactory");
            if (factoryClassName != null && (factoryClass = (AuditEventFactory)(factory = Class.forName(factoryClassName)).newInstance()) != null) {
                this.eventFactory = factoryClass;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.eventFactory = null;
        }
        if (this.eventFactory == null) {
            this.eventFactory = DefaultAuditEventFactory.getInstance();
        }
        this.reader = new BufferedReader(in);
    }

    public static int getSectionIndex(String line) {
        if (!line.matches("--[\\-0-9A-Za-z\\@]*-[A-Z]--")) {
            return -1;
        }
        char sect = line.charAt(line.length() - 3);
        if (log.isDebugEnabled()) {
            log.debug("looking up index for section >{}< (line: {}", (Object)String.valueOf(sect), (Object)line);
        }
        int i = 0;
        while (i < "ABCDEFGHIJKTXZ".length()) {
            if (sect == "ABCDEFGHIJKTXZ".charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double getFileSize() {
        return this.fileSize;
    }

    public double getDataRead() {
        return this.bytesRead;
    }

    @Override
    public abstract AuditEvent readNext() throws IOException, ParseException;

    public boolean hasNext() {
        return this.pending != null && !this.eofReached;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long bytesRead() {
        return (long)this.bytesRead;
    }

    @Override
    public long bytesAvailable() {
        if (this.fileSize >= 0.0) {
            return (long)this.fileSize;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public boolean atEOF() {
        return this.eofReached;
    }
}

