/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogAuditReader
extends AbstractAuditEventReader {
    private static Logger log = LoggerFactory.getLogger((String)"AccessLogAuditReader");

    public AccessLogAuditReader(File accessLogFile, boolean tail) throws IOException {
        super(new FileInputStream(accessLogFile));
        this.fileSize = accessLogFile.length();
        if (tail) {
            this.reader.skip(accessLogFile.length());
        }
    }

    public AccessLogAuditReader(File accessLogFile) throws IOException {
        super(new FileInputStream(accessLogFile));
        this.fileSize = accessLogFile.length();
    }

    public AccessLogAuditReader(InputStream in) {
        super(in);
    }

    @Override
    public AuditEvent readNext() {
        try {
            String line = this.reader.readLine();
            if (line != null) {
                this.bytesRead += (double)(line.length() + 1);
                return AccessLogAuditReader.createEvent(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] splitAccessLine(String input) {
        int e;
        int s;
        int lineNr = 0;
        input = input.replaceAll("\\\"", "\"");
        ++lineNr;
        StringBuffer line = new StringBuffer(input.replaceFirst("\\[", "\"").replaceFirst("\\]", "\""));
        int esc = 0;
        int k = 0;
        while (k < line.length()) {
            if (line.charAt(k) == '\"') {
                ++esc;
            }
            ++k;
        }
        if (esc % 2 > 0) {
            log.warn(String.valueOf(lineNr) + ": " + line);
            return null;
        }
        Vector<String> subs = new Vector<String>();
        do {
            s = line.indexOf("\"") - 1;
            e = line.indexOf("\"", s + 2) + 1;
            String satz = line.substring(s, e);
            subs.add(satz.substring(2, satz.length() - 1));
        } while ((line = line.replace(s, e, " $" + subs.size())).indexOf("\"") > 0);
        String[] token = line.toString().split(" ");
        int ptr = 0;
        int k2 = 0;
        while (k2 < token.length) {
            if (token[k2].matches("\\$\\d")) {
                token[k2] = (String)subs.elementAt(ptr++);
            }
            ++k2;
        }
        return token;
    }

    public static AuditEvent createEvent(String accessLine) throws Exception {
        String[] token = AccessLogAuditReader.splitAccessLine(accessLine);
        String[] data = new String["ABCDEFGHIJKTXZ".length()];
        String id = Long.toHexString(System.currentTimeMillis());
        int i = 0;
        while (i < data.length) {
            data[i] = "";
            ++i;
        }
        data[0] = "[" + token[3] + "] " + id + " " + token[0] + " ? 127.0.0.1 80";
        String method = "GET";
        String uri = token[4];
        String proto = "HTTP/1.1";
        String host = token[0];
        String[] req = token[4].split(" ");
        if (req.length > 1) {
            method = req[0];
            uri = req[1];
        }
        if (req.length > 2) {
            proto = req[2];
        }
        StringBuffer h = new StringBuffer();
        h.append(String.valueOf(method) + " " + uri + " " + proto + "\n");
        h.append("Host: " + host + "\n");
        if (token.length > 8) {
            h.append("User-Agent: " + token[8] + "\n");
        }
        if (token.length > 7 && token[5] != null && !"".equals(token[7]) && !"-".equals(token[7])) {
            h.append("Referer: " + token[7] + "\n");
        }
        h.append("\n");
        data[1] = h.toString();
        StringBuffer r = new StringBuffer();
        r.append(String.valueOf(proto) + " " + token[5] + "\n");
        r.append("\n");
        data[5] = r.toString();
        return new ModSecurityAuditEvent(data, AuditEventType.ModSecurity2);
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

