/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jwall.web.audit.io.ParseException;
import org.jwall.web.audit.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventParser {
    static Logger log = LoggerFactory.getLogger((String)AuditEventParser.class.getName());
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d/MMM/y:HH:mm:ss Z", Locale.ENGLISH);
    private static final String RULE_FILE_PREFIX = "[file ";
    private static final String RULE_LINE_PREFIX = "[line ";
    private static final String RULE_ID_PREFIX = "[id ";
    private static final String RULE_MSG_PREFIX = "[msg ";
    private static final String RULE_SEVERITY_PREFIX = "[severity ";
    private static final String RULE_TAG_PREFIX = "[tag ";
    protected static final String[] extractTrailer = new String[]{"[file ", "RULE_FILE", "[line ", "RULE_LINE", "[id ", "RULE_ID", "[msg ", "RULE_MSG", "[tag ", "RULE_TAG", "[severity ", "RULE_SEV"};

    public static Map<String, List<String>> parseHttpHeader(Map<String, List<String>> cols, String header) throws ParseException {
        BufferedReader r = new BufferedReader(new StringReader(header));
        Hashtable<String, String> headers = new Hashtable<String, String>();
        try {
            String line = r.readLine();
            String headerCollection = "REQUEST_HEADERS";
            while (line != null && line.equals("")) {
                line = r.readLine();
            }
            if (line == null) {
                log.debug("No header found, possbile due to an invalid client request!");
                return cols;
            }
            if (line.startsWith("HTTP")) {
                headerCollection = "RESPONSE_HEADERS";
                AuditEventParser.addValue(cols, "RESPONSE_LINE", line);
                String[] d = line.split(" ");
                AuditEventParser.addValue(cols, "RESPONSE_STATUS", d[1]);
            } else {
                AuditEventParser.addValue(cols, "REQUEST_LINE", line);
                int idx1 = line.indexOf(" ");
                int idx2 = line.lastIndexOf(" ");
                String requestUriRaw = "";
                try {
                    requestUriRaw = line.substring(idx1 + 1, idx2);
                    AuditEventParser.addValue(cols, "REQUEST_METHOD", line.substring(0, idx1));
                    AuditEventParser.addValue(cols, "REQUEST_URI_RAW", requestUriRaw);
                }
                catch (Exception e) {
                    throw new ParseException("Failed to split the request-line: \"" + line + "\", error is " + e.getMessage());
                }
                if (idx2 > 0) {
                    String proto = line.substring(idx2 + 1);
                    AuditEventParser.addValue(cols, "REQUEST_PROTOCOL", proto);
                } else {
                    AuditEventParser.addValue(cols, "REQUEST_PROTOCOL", "");
                }
                String queryString = "";
                StringBuffer requestUri = new StringBuffer();
                int qsSeparatorIndex = requestUriRaw.indexOf("?");
                int uriStart = 0;
                if (requestUriRaw.toLowerCase().startsWith("http://") && (uriStart = requestUriRaw.indexOf("/", "http://".length())) < 0) {
                    uriStart = "http://".length();
                }
                if (qsSeparatorIndex > 0) {
                    requestUri = requestUri.append(requestUriRaw.substring(uriStart, qsSeparatorIndex));
                    queryString = requestUriRaw.substring(qsSeparatorIndex + 1);
                } else {
                    queryString = "";
                    requestUri.append(requestUriRaw);
                }
                AuditEventParser.addValue(cols, "REQUEST_URI", requestUri.toString());
                AuditEventParser.addValue(cols, "QUERY_STRING", queryString);
            }
            while (r.ready() && line != null) {
                line = r.readLine();
                if ("".equals(line) || line == null) continue;
                String[] pairs = line.split(":", 2);
                if (pairs.length == 2) {
                    while (pairs[1].startsWith(" ")) {
                        pairs[1] = pairs[1].substring(1);
                    }
                    headers.put(pairs[0], pairs[1]);
                    AuditEventParser.addValue(cols, String.valueOf(headerCollection) + ":" + pairs[0], pairs[1]);
                    AuditEventParser.addValue(cols, String.valueOf(headerCollection) + ":" + pairs[0].toUpperCase(), pairs[1]);
                    AuditEventParser.addValue(cols, String.valueOf(headerCollection) + "_NAMES", pairs[0]);
                    AuditEventParser.addValue(cols, headerCollection, pairs[1]);
                    if ("Cookie".equalsIgnoreCase(pairs[0]) && !"".equals(pairs[1])) {
                        AuditEventParser.parseCookies(cols, "REQUEST_COOKIES", pairs[1]);
                        AuditEventParser.addValue(cols, "REQUEST_COOKIES", pairs[1]);
                    }
                    if (!"Set-Cookie".equalsIgnoreCase(pairs[0]) || "".equals(pairs[1])) continue;
                    AuditEventParser.parseCookies(cols, "RESPONSE_COOKIES", pairs[1]);
                    AuditEventParser.addValue(cols, "RESPONSE_COOKIES", pairs[1]);
                    continue;
                }
                throw new ParseException("invalid response-header-line: " + line + "\nrequest:\n" + header);
            }
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        return cols;
    }

    private static Map<String, List<String>> parseCookies(Map<String, List<String>> cols, String selector, String c) {
        String[] ct = c.split("(;|,)");
        int i = 0;
        while (i < ct.length) {
            String[] av;
            ct[i] = ct[i].trim();
            if (ct[i].matches("\\w*=.*") && (av = ct[i].split("=")).length == 2) {
                AuditEventParser.addValue(cols, String.valueOf(selector) + ":" + av[0], av[1]);
                AuditEventParser.addValue(cols, String.valueOf(selector) + "_NAMES", av[0]);
            }
            ++i;
        }
        return cols;
    }

    public static void parseParameters(Map<String, List<String>> cols, String selector, String qs) {
        String ct;
        if (qs != "REQUEST_BODY") {
            Hashtable<String, String> params = ParserUtils.parseQueryString(qs);
            for (String key : params.keySet()) {
                String val = (String)params.get(key);
                AuditEventParser.addValue(cols, "ARGS_NAMES", key);
                AuditEventParser.addValue(cols, "ARGS", val);
                AuditEventParser.addValue(cols, "ARGS_GET", val);
                AuditEventParser.addValue(cols, "ARGS:" + key, val);
            }
            return;
        }
        if (cols.get("REQUEST_BODY") == null) {
            return;
        }
        String body = cols.get("REQUEST_BODY").get(0);
        if (!"".equals(body.trim()) && (ct = cols.get("REQUEST_HEADERS:Content-Type").get(0)) != null && ct.indexOf("multipart/form-data") > 0) {
            try {
                String contentType = cols.get("Content-Type").get(0);
                AuditEventParser.addValue(cols, "SECTION_FORM_DATA", ParserUtils.extractFormData(contentType, body));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Hashtable<String, String> postParams = ParserUtils.parseQueryString(body);
            for (String key : postParams.keySet()) {
                String val = (String)postParams.get(key);
                AuditEventParser.addValue(cols, "ARGS:" + key, val);
                AuditEventParser.addValue(cols, "ARGS_POST:" + key, val);
                AuditEventParser.addValue(cols, "ARGS_NAMES", key);
                AuditEventParser.addValue(cols, "ARGS_POST_NAMES", key);
            }
        }
    }

    public static Map<String, List<String>> parseAuditTrailer(Map<String, List<String>> cols, String trailer) throws ParseException {
        return cols;
    }

    public static void addValue(Map<String, List<String>> cols, String col, String value) {
        List<String> collection = cols.get(col);
        if (collection == null) {
            collection = new LinkedList<String>();
            cols.put(col, collection);
        }
        collection.add(value);
    }

    public static void setValue(Map<String, List<String>> cols, String key, String value) {
        List<String> list = cols.get(key);
        if (list == null) {
            list = new LinkedList<String>();
            list.add(value);
            cols.put(key, list);
        } else {
            list.clear();
            list.add(value);
        }
    }

    public static Date parseDate(String s) {
        Date d;
        int idx = 0;
        String str = "";
        try {
            idx = s.indexOf("] ");
            str = s.substring(1, idx);
            d = DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            try {
                str = str.replaceAll("--", "-");
                log.trace("Trying to parse date from '{}'", (Object)str);
                d = DATE_FORMAT.parse(str);
            }
            catch (Exception e1) {
                d = new Date();
                log.trace("string is: {}", (Object)str);
            }
        }
        return d;
    }

    public static Map<String, List<String>> parseAuditLogHeader(Map<String, List<String>> collections, String auditLogHeader) throws ParseException {
        String[] s = auditLogHeader.trim().split(" ");
        if (s.length < 7) {
            throw new ParseException("Unexpected number of columns in AUDIT_LOG_HEADER! Columns found:" + s.length + ", expected: 7!");
        }
        Date createdAt = AuditEventParser.parseDate(s[0]);
        AuditEventParser.addValue(collections, "EVENT_ID", Long.toHexString(createdAt.getTime()));
        AuditEventParser.addValue(collections, "UNIQUE_ID", s[2]);
        AuditEventParser.addValue(collections, "TX_ID", s[2]);
        AuditEventParser.addValue(collections, "REMOTE_ADDR", s[3]);
        AuditEventParser.addValue(collections, "REMOTE_HOST", s[3]);
        AuditEventParser.addValue(collections, "REMOTE_PORT", s[4]);
        AuditEventParser.addValue(collections, "SERVER_ADDR", s[5]);
        AuditEventParser.addValue(collections, "SERVER_NAME", s[5]);
        if (s[6].equals("www")) {
            s[6] = "80";
        }
        AuditEventParser.addValue(collections, "SERVER_PORT", s[6]);
        AuditEventParser.addValue(collections, "REMOTE_USER", "-");
        return collections;
    }

    public static Map<String, String> parseMetaInfSection(Map<String, List<String>> collections, String metaInfSection) throws ParseException {
        Map<String, String> variables = AuditEventParser.readMetaInf(metaInfSection);
        for (String key : variables.keySet()) {
            AuditEventParser.addValue(collections, key, variables.get(key));
        }
        return variables;
    }

    public static Map<String, String> readMetaInf(String metaInfSection) throws ParseException {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        try {
            BufferedReader r = new BufferedReader(new StringReader(metaInfSection));
            String line = r.readLine();
            while (line != null) {
                int idx = line.indexOf("=");
                if (idx > 0) {
                    String key = line.substring(0, idx);
                    String val = line.substring(idx + 1);
                    variables.put(key, val);
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variables;
    }

    public static String storeMetaInf(Map<String, String> data) {
        StringBuffer s = new StringBuffer();
        for (String key : data.keySet()) {
            s.append(key);
            s.append("=");
            s.append(data.get(key));
            s.append("\n");
        }
        return s.toString();
    }
}

