/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.io.AuditEventWriter;
import org.jwall.web.audit.util.MD5;

public class ConcurrentAuditWriter
implements AuditEventWriter {
    public static final SimpleDateFormat DIR_FORMAT = new SimpleDateFormat("yyyyMMdd/yyyyMMdd-HHmm");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]");
    private File dir = null;
    private File idx = null;
    int count = 0;
    PrintStream indexWriter;

    public ConcurrentAuditWriter(File baseDir, File indexFile) throws IOException {
        this.dir = baseDir;
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            throw new IOException("Cannot create directory " + this.dir.getAbsolutePath());
        }
        if (!this.dir.isDirectory() || !this.dir.canWrite()) {
            throw new IOException("Cannot write to " + this.dir.getAbsolutePath());
        }
        this.idx = indexFile;
        this.indexWriter = new PrintStream(new FileOutputStream(this.idx, true));
    }

    public ConcurrentAuditWriter(File baseDir) throws IOException {
        this(baseDir, new File(String.valueOf(baseDir.getAbsolutePath()) + "/index"));
    }

    public File write(AuditEvent evt) throws IOException {
        PrintStream wr = null;
        try {
            File f = this.getFileFor(evt);
            wr = new PrintStream(new FileOutputStream(f, true));
            wr.print(evt.toString());
            wr.flush();
            wr.close();
            ++this.count;
            this.indexWriter.println(ConcurrentAuditWriter.createSummary(evt));
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getFileFor(AuditEvent evt) throws IOException {
        SimpleDateFormat ff = new SimpleDateFormat("yyyyMMdd-HHmmss-");
        File dir = this.getDirectoryFor(evt.getDate());
        File f = new File(String.valueOf(dir.getAbsolutePath()) + "/" + ff.format(evt.getDate()) + evt.getEventId());
        int j = 0;
        while (f.exists()) {
            f = f.getAbsolutePath().endsWith("_" + (j - 1)) ? new File(f.getAbsolutePath().replaceAll("_\\d+$", "_" + j)) : new File(String.valueOf(f.getAbsolutePath()) + "_" + j);
            ++j;
        }
        return f;
    }

    @Override
    public void writeEvent(AuditEvent evt) throws IOException {
        this.write(evt);
    }

    public File getDirectoryFor(Date date) throws IOException {
        File f = new File(String.valueOf(this.dir.getAbsolutePath()) + File.separator + DIR_FORMAT.format(date));
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new IOException("Could not create directory " + f.getAbsolutePath());
        }
        return f;
    }

    public static String createSummary(AuditEvent evt) {
        SimpleDateFormat fn = new SimpleDateFormat("/yyyyMMdd/yyyyMMdd-HHmm/yyyyMMdd-HHmmss-");
        String hash = MD5.md5(evt.toString().getBytes());
        StringBuffer sum = new StringBuffer();
        sum.append(evt.get("REQUEST_HEADERS:Host"));
        sum.append(" ");
        sum.append(evt.get("REMOTE_ADDR"));
        sum.append(" - - ");
        sum.append(DATE_FORMAT.format(evt.getDate()));
        sum.append(" ");
        sum.append("\"" + evt.get("REQUEST_LINE") + "\"");
        sum.append(" ");
        sum.append(evt.get("RESPONSE_STATUS"));
        sum.append(" 0");
        sum.append(" \"-\"");
        sum.append(" \"-\"");
        sum.append(" " + evt.getEventId());
        sum.append(" \"" + evt.getSessionId() + "\" ");
        sum.append(fn.format(evt.getDate()));
        sum.append(evt.getEventId());
        sum.append(" 0 ");
        sum.append(evt.toString().length());
        sum.append(" md5:" + hash);
        return sum.toString();
    }
}

