/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentDirectoryReader
implements AuditEventReader {
    static Logger log = LoggerFactory.getLogger(ConcurrentDirectoryReader.class);
    File dir;
    LinkedList<File> files = new LinkedList();
    Integer total = 0;
    Integer read = 0;
    ModSecurity2AuditReader reader;

    public ConcurrentDirectoryReader(File directory) throws IOException {
        this.dir = directory;
        if (!this.dir.isDirectory()) {
            throw new IOException("Specified file '" + directory.getAbsolutePath() + "' is not a directory!");
        }
        if (!this.dir.canRead()) {
            throw new IOException("Cannot open directory '" + this.dir.getAbsolutePath() + "' for reading!");
        }
        this.files.addAll(this.findFiles(this.dir));
        this.total = this.files.size();
        log.debug("Found {} files...", (Object)this.total);
        this.read = 0;
        this.reader = new ModSecurity2AuditReader(this.files.removeFirst());
    }

    protected List<File> findFiles(File directory) {
        log.debug("Adding files from directory '{}'", (Object)directory);
        LinkedList<File> files = new LinkedList<File>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.canRead()) {
                log.debug("  Adding file '{}'", (Object)file);
                files.add(file);
            } else {
                files.addAll(this.findFiles(file));
            }
            ++n2;
        }
        return files;
    }

    @Override
    public boolean atEOF() {
        return this.files.isEmpty();
    }

    @Override
    public long bytesAvailable() {
        return this.total.intValue();
    }

    @Override
    public long bytesRead() {
        return this.read.intValue();
    }

    @Override
    public void close() throws IOException {
        this.files.clear();
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        AuditEvent evt = null;
        File file = null;
        if (this.reader != null) {
            log.debug("Trying to read next event from current file...");
            try {
                evt = this.reader.readNext();
                if (evt != null) {
                    return evt;
                }
            }
            catch (Exception e) {
                this.reader.close();
                this.reader = null;
                log.error("Failed to read more events from current file, processing next file...");
                e.printStackTrace();
            }
        }
        while (!this.files.isEmpty()) {
            try {
                this.total = this.total - 1;
                file = this.files.removeFirst();
                this.reader = new ModSecurity2AuditReader(file, false);
                evt = this.reader.readNext();
                if (evt == null) continue;
                return evt;
            }
            catch (Exception e) {
                log.error("Failed to read event from file '{}': {}", file, (Object)e.getMessage());
            }
        }
        return evt;
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        log.error("This reader does not implement the iterator function!");
        return null;
    }
}

