/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSecurity2AuditReader
extends AbstractAuditEventReader
implements AuditEventReader {
    static Logger log = LoggerFactory.getLogger(ModSecurity2AuditReader.class);
    boolean tail;

    public ModSecurity2AuditReader(InputStream in) throws IOException {
        this(in, true);
    }

    public ModSecurity2AuditReader(InputStream in, boolean persist) throws IOException {
        super(in);
        this.tail = persist;
    }

    public ModSecurity2AuditReader(File file, boolean tail) throws IOException {
        this(new FileInputStream(file));
        this.inputFile = file;
        this.fileSize = file.length();
        this.tail = tail;
        if (this.tail) {
            this.reader.skip(file.length());
        }
    }

    public ModSecurity2AuditReader(File file) throws IOException {
        this(file, false);
    }

    public ModSecurity2AuditReader(Reader inputReader) throws IOException {
        super(inputReader);
        this.tail = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        log.debug("readEvent " + this.counter);
        ++this.counter;
        String line = "";
        long offset = (long)this.getDataRead();
        try {
            this.reader.mark(0x100000);
        }
        catch (Exception e) {
            log.error("Failed to set marker at offset {}: {}", (Object)offset, (Object)e);
            return null;
        }
        StringBuffer[] sections = new StringBuffer["ABCDEFGHIJKTXZ".length()];
        int i = 0;
        while (i < sections.length) {
            sections[i] = new StringBuffer();
            ++i;
        }
        int ptr = 0;
        try {
            while (this.reader.ready() && !line.matches("--[\\-\\@0-9A-Za-z]*-A--")) {
                try {
                    line = this.reader.readLine();
                }
                catch (EOFException eof) {
                    boolean bl = this.eofReached = !this.tail;
                }
                if (line == null) {
                    this.reader.reset();
                    return null;
                }
                this.bytesRead += (double)line.length() + 1.0;
            }
            String id = line.replaceFirst("--", "").replaceAll("-A--", "");
            while (!line.startsWith("--") || !line.endsWith("-Z--")) {
                log.debug("line: {}", (Object)line);
                ptr = ModSecurity2AuditReader.getSectionIndex(line);
                line = this.reader.readLine();
                if (line == null) {
                    if (this.reader.markSupported()) {
                        this.reader.reset();
                    }
                    return null;
                }
                this.bytesRead += (double)line.length() + 1.0;
                if (ptr < 0) {
                    log.debug("Line contains invalid section-name: " + line);
                    continue;
                }
                sections[ptr] = new StringBuffer();
                do {
                    sections[ptr].append(String.valueOf(line) + "\n");
                    line = this.reader.readLine();
                    if (line == null) {
                        this.reader.reset();
                        return null;
                    }
                    this.bytesRead += (double)line.length();
                    log.debug("line: {}", (Object)line);
                } while (!line.trim().matches("^--.*-[A-Z]--$"));
            }
            String[] data = new String["ABCDEFGHIJKTXZ".length()];
            int i2 = 0;
            while (i2 < data.length) {
                data[i2] = sections[i2].toString();
                ++i2;
            }
            if (data[0].equals("")) {
                return null;
            }
            return this.eventFactory.createAuditEvent(id, data, this.inputFile, offset, (long)this.bytesRead - offset, AuditEventType.ModSecurity2);
        }
        catch (EOFException eof) {
            this.eofReached = true;
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

