/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSecurityAuditReader
extends AbstractAuditEventReader {
    static Logger log = LoggerFactory.getLogger(ModSecurityAuditReader.class);

    public ModSecurityAuditReader(File f) throws IOException {
        super(new FileInputStream(f));
    }

    public ModSecurityAuditReader(InputStream in) {
        super(in);
    }

    public ModSecurityAuditReader(File f, boolean tail) throws IOException {
        this(f);
        if (tail) {
            this.reader.skip(f.length());
        }
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        String line;
        block18: {
            line = this.reader.readLine();
            while (this.reader.ready() && line != null && !line.matches("==[A-Fa-f0-9]*=*")) {
                line = this.reader.readLine();
            }
            if (line != null) break block18;
            return null;
        }
        try {
            log.debug("Found separator line: {}", (Object)line);
            String id = line.replaceAll("=", "");
            line = this.reader.readLine();
            if (line == null || !this.reader.ready()) {
                log.error("Line is null and reader not ready...aborting.");
                throw new Exception("Error !!");
            }
            String[] access = this.parseAccessLogLine(line);
            String transformedHeader = "[" + access[5] + "] " + id + " " + access[2] + " 0 " + access[1] + " 80\n";
            while (line != null && !line.startsWith("------------")) {
                log.debug("Skipping line: {}", (Object)line);
                line = this.reader.readLine();
            }
            StringBuffer msg = new StringBuffer();
            StringBuffer request = new StringBuffer();
            int contentLength = -1;
            do {
                if ((line = this.reader.readLine()) == null) continue;
                if (line.startsWith("mod_security")) {
                    msg.append(line);
                    msg.append("\n");
                } else {
                    request.append(line);
                    request.append("\n");
                }
                if (!line.startsWith("Content-Length")) continue;
                contentLength = Integer.parseInt(line.substring("Content-Length: ".length()));
            } while (line != null && !line.equals(""));
            StringBuffer reqBody = new StringBuffer();
            if (contentLength > 0) {
                this.reader.readLine();
                char[] body = new char[contentLength];
                int read = this.reader.read(body);
                if (read != body.length) {
                    throw new Exception("Did not read as much bytes as expected!");
                }
                reqBody.append(body);
            }
            boolean csRead = false;
            while (line != null && !line.startsWith("HTTP")) {
                while ("".equals(line = this.reader.readLine())) {
                }
                if (line == null || line.startsWith("HTTP")) continue;
                if (!csRead && line.matches("[A-Fa-f0-9]*")) {
                    csRead = true;
                    continue;
                }
                reqBody.append(line);
                reqBody.append("\n");
            }
            StringBuffer response = new StringBuffer();
            while (line != null && !line.equals("") && !line.matches("^--[A-Fa-f0-9]*--")) {
                if (!line.startsWith("=====")) {
                    response.append(line);
                    response.append("\n");
                }
                line = this.reader.readLine();
            }
            response.append("\n");
            String[] data = new String["ABCDEFGHIJKTXZ".length() + 1];
            int i = 0;
            while (i < data.length) {
                data[i] = "";
                if (i == 0) {
                    data[i] = "";
                }
                ++i;
            }
            data[0] = transformedHeader;
            data[1] = request.toString();
            data[2] = reqBody.toString();
            data[5] = response.toString();
            data[7] = msg.toString();
            return new ModSecurityAuditEvent(data, AuditEventType.ModSecurity2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] parseAccessLogLine(String input) throws ParseException {
        int e;
        int s;
        int lineNr = 0;
        ++lineNr;
        StringBuffer line = new StringBuffer(input.replaceFirst("\\[", "\"").replaceFirst("\\]", "\""));
        int esc = 0;
        int k = 0;
        while (k < line.length()) {
            if (line.charAt(k) == '\"') {
                ++esc;
            }
            ++k;
        }
        if (esc % 2 > 0) {
            throw new ParseException("Error in line " + lineNr + ": Number of '\"' characters is odd!");
        }
        Vector<String> subs = new Vector<String>();
        do {
            s = line.indexOf("\"") - 1;
            e = line.indexOf("\"", s + 2) + 1;
            String satz = line.substring(s, e);
            subs.add(satz.substring(2, satz.length() - 1));
        } while ((line = line.replace(s, e, " $" + subs.size())).indexOf("\"") > 0);
        String[] token = line.toString().split(" ");
        int ptr = 0;
        int k2 = 0;
        while (k2 < token.length) {
            if (token[k2].matches("\\$\\d")) {
                token[k2] = (String)subs.elementAt(ptr++);
            }
            ++k2;
        }
        return token;
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

