/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jwall.web.audit.AuditEventDispatcher;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.AuditFormat;
import org.jwall.web.audit.util.RFICollector;
import org.jwall.web.audit.util.RFICollectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFICollectorServer
extends UnicastRemoteObject
implements RFICollectorService {
    private static final long serialVersionUID = -1459208475221129186L;
    public static final int REGISTRY_PORT = 1099;
    static Registry registry;
    static Logger log;
    private HashMap<String, AuditEventDispatcher> sources = new HashMap();

    static {
        log = LoggerFactory.getLogger((String)"RFICollectorServer");
    }

    @Override
    public void registerCollector(String file, Properties p) throws RemoteException {
        AuditEventDispatcher source = null;
        if (!this.sources.containsKey(file)) {
            try {
                boolean tail = "true".equals(p.getProperty("org.jwall.rfi.tail"));
                AuditEventReader reader = AuditFormat.createReader(file, tail);
                AuditEventDispatcher evtSource = new AuditEventDispatcher(reader);
                this.sources.put(file, evtSource);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
        }
        source = this.sources.get(file);
        File outputdir = new File("/tmp/rfi-collector");
        outputdir.mkdirs();
        try {
            RFICollector collector = new RFICollector(null, p);
            source.addAuditEventListener(collector);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (!source.isAlive() && source.getAuditEventListeners().size() > 0) {
            source.start();
        } else {
            this.sources.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCollector(String file) throws RemoteException {
        HashMap<String, AuditEventDispatcher> hashMap = this.sources;
        synchronized (hashMap) {
            if (this.sources.containsKey(file)) {
                AuditEventDispatcher d = this.sources.get(file);
                d.removeAuditEventListeners();
                this.sources.remove(file);
                try {
                    d.close();
                }
                catch (IOException ie) {
                    throw new RemoteException(ie.getMessage());
                }
            } else {
                log.info("No collector listening on " + file);
            }
        }
    }

    @Override
    public List<String> listCollectors() throws RemoteException {
        LinkedList<String> list = new LinkedList<String>();
        for (String file : this.sources.keySet()) {
            list.add(String.valueOf(file) + " (" + this.sources.get(file).getNumberOfEvents() + " events)");
        }
        return list;
    }

    public static void initRegistry() throws Exception {
        try {
            registry = LocateRegistry.getRegistry("127.0.0.1", 1099);
            log.debug("Found registry: " + registry);
        }
        catch (Exception e) {
            registry = null;
        }
        if (registry == null) {
            log.debug("Creating new registry...");
            registry = LocateRegistry.createRegistry(1099);
            registry = LocateRegistry.getRegistry(1099);
        }
    }

    public static void main(String[] args) {
        try {
            System.setProperty("java.rmi.hostname", "127.0.0.1");
            log.info("Initializing registry...");
            RFICollectorServer.initRegistry();
            log.info("Creating collector server...");
            RFICollectorServer server = new RFICollectorServer();
            log.info("Registering collector server to registry...");
            registry.rebind("RFICollectorService", server);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

