/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableContext {
    static Logger log = LoggerFactory.getLogger(VariableContext.class);
    public static final String VAR_PREFIX = "${";
    public static final String VAR_SUFFIX = "}";
    Map<String, String> variables = new HashMap<String, String>();

    public VariableContext(VariableContext root) {
        this.variables = new HashMap<String, String>();
        if (root.variables != null) {
            this.variables.putAll(root.variables);
        }
    }

    public VariableContext(Map<String, String> variables) {
        this.variables = variables;
    }

    public VariableContext(Properties p) {
        this.variables = new HashMap<String, String>();
        for (Object k : p.keySet()) {
            this.variables.put(k.toString(), p.getProperty(k.toString()));
        }
    }

    public void addVariables(Map<String, String> vars) {
        for (String key : vars.keySet()) {
            this.variables.put(key, vars.get(key));
        }
    }

    public void set(String key, String val) {
        this.variables.put(key, val);
    }

    public String expand(String str) {
        return this.substitute(str);
    }

    private String substitute(String str) {
        String content = str;
        int start = content.indexOf(VAR_PREFIX, 0);
        while (start >= 0) {
            int end = content.indexOf(VAR_SUFFIX, start);
            if (end >= start + 2) {
                String variable = content.substring(start + 2, end);
                log.debug("Found variable: {}", (Object)variable);
                log.trace("   content is: {}", (Object)content);
                content = this.variables.containsKey(variable) ? String.valueOf(content.substring(0, start)) + this.variables.get(variable) + content.substring(end + 1) : String.valueOf(content.substring(0, start)) + content.substring(end + 1);
                if (end < content.length()) {
                    start = content.indexOf(VAR_PREFIX, end);
                    continue;
                }
                start = -1;
                continue;
            }
            start = -1;
        }
        return content;
    }
}

