/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedReadableByteChannel
implements ReadableByteChannel {
    Logger log = LoggerFactory.getLogger((String)"BufferedReadableByteChannel.class");
    ReadableByteChannel ch;
    ByteBuffer buf;
    int bufferSize = 32768;
    StringBuffer s = new StringBuffer();

    public BufferedReadableByteChannel(ReadableByteChannel input) {
        this(input, 32768);
    }

    public BufferedReadableByteChannel(ReadableByteChannel input, int bufSize) {
        this.ch = input;
        this.bufferSize = bufSize;
        this.buf = null;
    }

    private int indexOf(ByteBuffer buf, byte[] b) {
        int start = buf.position();
        int i = 0;
        while (i + b.length <= buf.remaining()) {
            boolean match = true;
            int k = 0;
            while (k < b.length && match && i + k < buf.limit()) {
                byte c = buf.get(start + i + k);
                match = match && c == b[k];
                ++k;
            }
            if (match && i < buf.capacity()) {
                buf.position(start);
                return start + i;
            }
            ++i;
        }
        buf.position(start);
        return -1;
    }

    public String readLine() throws IOException {
        int bytes;
        byte[] CRLF = new byte[]{-96, -48};
        CRLF = new byte[]{10};
        if (this.buf == null) {
            this.buf = ByteBuffer.allocate(this.bufferSize);
            bytes = this.ch.read(this.buf);
            if (bytes < 0) {
                this.ch.close();
                return new String(this.buf.asCharBuffer().array());
            }
            if (bytes == 0) {
                this.buf = null;
                return null;
            }
            this.buf.flip();
        }
        if (this.buf.remaining() == 0) {
            this.buf.clear();
            bytes = this.ch.read(this.buf);
            this.buf.flip();
            this.log.debug("refilled the buffer with {} new bytes of data", (Object)bytes);
            if (bytes == 0) {
                return null;
            }
        }
        StringBuffer s = new StringBuffer();
        int start = this.buf.position();
        int end = this.indexOf(this.buf, CRLF);
        if (end >= 0) {
            byte[] data = new byte[(end += CRLF.length) - start];
            this.buf.get(data);
            s.append(new String(data));
            String str = new String(s.toString());
            s = new StringBuffer();
            return str;
        }
        byte[] data = new byte[this.buf.remaining()];
        this.buf.get(data);
        s.append(new String(data));
        this.buf.clear();
        this.buf = null;
        return null;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.buf == null) {
            if (!this.ch.isOpen()) {
                return -1;
            }
            this.buf = ByteBuffer.allocate(this.bufferSize);
            int bytes = this.ch.read(this.buf);
            this.log.debug("Read {} bytes of data into buffer...", (Object)bytes);
            this.buf.flip();
        }
        if (!this.ch.isOpen()) {
            return -1;
        }
        int pos = this.buf.position();
        if (dst.remaining() <= this.buf.remaining()) {
            while (dst.remaining() > 0) {
                dst.put(this.buf.get());
            }
            return this.buf.position() - pos;
        }
        int bytes = this.buf.remaining();
        while (dst.hasRemaining() && this.buf.hasRemaining()) {
            dst.put(this.buf.get());
        }
        this.buf = null;
        if ((bytes += this.ch.read(dst)) > 0) {
            return bytes;
        }
        if (!this.ch.isOpen()) {
            return -1;
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }
}

